/*
 * Decompiled with CFR 0.152.
 */
package com.futronictech.fs28;

import com.futronictech.fs28.SPPScreen;
import net.rim.device.api.bluetooth.BluetoothSerialPort;
import net.rim.device.api.bluetooth.BluetoothSerialPortInfo;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.container.MainScreen;

public final class AppScreen
extends MainScreen {
    private BluetoothSerialPortInfo[] _portInfo;
    private MenuItem _listenItem = new MenuItem("Listen for FS28", 30, 30){

        public void run() {
            UiApplication.getUiApplication().pushScreen((Screen)new SPPScreen(null));
        }
    };

    public AppScreen() {
        this.setTitle("FS28 Bluetooth Master Mode Demo V3.0");
        if (BluetoothSerialPort.isSupported()) {
            this._portInfo = BluetoothSerialPort.getSerialPortInfo();
            int numServices = this._portInfo.length;
            int count = numServices - 1;
            while (count >= 0) {
                String strDeviceName = this._portInfo[count].getDeviceName();
                if (strDeviceName.equals("FS28")) {
                    DeviceMenuItem deviceMenuItem = new DeviceMenuItem("Connect to: " + strDeviceName, this._portInfo[count]);
                    this.addMenuItem(deviceMenuItem);
                }
                --count;
            }
            this.addMenuItem(this._listenItem);
        } else {
            this.add((Field)new LabelField((Object)"Bluetooth is not supported on this device."));
        }
    }

    private final class DeviceMenuItem
    extends MenuItem {
        private BluetoothSerialPortInfo _info;

        DeviceMenuItem(String text, BluetoothSerialPortInfo info) {
            super(text, 20, 20);
            this._info = info;
        }

        public void run() {
            UiApplication.getUiApplication().pushScreen((Screen)new SPPScreen(this._info));
        }
    }
}

