/*
 * Decompiled with CFR 0.152.
 */
package com.futronictech.fs28;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Manager;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.XYEdges;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.ListField;
import net.rim.device.api.ui.component.ObjectListField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.container.DialogFieldManager;
import net.rim.device.api.ui.container.PopupScreen;
import net.rim.device.api.ui.decor.Border;
import net.rim.device.api.ui.decor.BorderFactory;

public class FileSelectorPopupScreen
extends PopupScreen {
    String _currentPath;
    String _extensions;
    RichTextField _rtfPath;
    ObjectListField _olf;
    BasicEditField _bef;
    ButtonField _bfOK;

    public FileSelectorPopupScreen() {
        this(null, null);
    }

    public FileSelectorPopupScreen(String startPath, String extensions) {
        super((Manager)new DialogFieldManager());
        this._extensions = extensions;
        this.prepScreen(startPath);
    }

    public void pickFile() {
        UiApplication.getUiApplication().pushModalScreen((Screen)this);
    }

    public String getFile() {
        return this._currentPath;
    }

    private void prepScreen(String path) {
        DialogFieldManager dfm = (DialogFieldManager)this.getDelegate();
        dfm.setIcon(new BitmapField(Bitmap.getPredefinedBitmap((int)1)));
        this._rtfPath = new RichTextField("Select a folder");
        dfm.setMessage(this._rtfPath);
        this._olf = new ObjectListField();
        dfm.addCustomField((Field)this._olf);
        this._bef = new BasicEditField("File Name:", "", 30, 0x10000000000000L);
        dfm.addCustomField((Field)this._bef);
        this._bfOK = new ButtonField(" OK ", 0x100010000L);
        this._bfOK.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field arg0, int arg1) {
                FileSelectorPopupScreen.this.onOK();
            }
        });
        dfm.addCustomField((Field)this._bfOK);
        if (this._extensions != null) {
            this._bef.setLabel("File name (." + this._extensions + "): ");
        }
        XYEdges padding = new XYEdges(15, 15, 15, 15);
        int color = 32768;
        int lineStyle = 8;
        Border roundedBorder = BorderFactory.createRoundedBorder((XYEdges)padding, (int)color, (int)lineStyle);
        this._bef.setBorder(roundedBorder);
        this.updateList(path);
    }

    private Vector readFiles(String path) {
        Vector filesVector = new Vector();
        this._currentPath = path;
        if (path == null) {
            Enumeration fileEnum = FileSystemRegistry.listRoots();
            while (fileEnum.hasMoreElements()) {
                filesVector.addElement(fileEnum.nextElement());
            }
        } else {
            try {
                FileConnection fc = (FileConnection)Connector.open((String)("file:///" + path));
                Enumeration fileEnum = fc.list();
                while (fileEnum.hasMoreElements()) {
                    String currentFile = (String)fileEnum.nextElement();
                    if (currentFile.lastIndexOf(47) != currentFile.length() - 1) continue;
                    filesVector.addElement(currentFile);
                }
            }
            catch (Exception ex) {
                Dialog.alert((String)("Unable to open folder. " + ex.toString()));
            }
        }
        return filesVector;
    }

    private void onOK() {
        String strFileName = this._bef.getText().trim();
        if (strFileName.length() == 0) {
            Dialog.alert((String)"Please enter file name.");
            this._bef.setFocus();
            return;
        }
        if (this._extensions != null) {
            strFileName = String.valueOf(strFileName) + "." + this._extensions;
        }
        try {
            int nRet;
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + this._currentPath + strFileName), (int)1);
            if (fc.exists() && (nRet = Dialog.ask((int)3, (String)"File existed. Are you sure to overwrite?", (int)-1)) == -1) {
                fc.close();
                this._bef.setFocus();
                return;
            }
            fc.close();
        }
        catch (Exception ex) {
            Dialog.alert((String)("Unable to open file. " + ex.toString()));
            return;
        }
        this._currentPath = "file:///" + this._currentPath + strFileName;
        this.close();
    }

    private void doSelection() {
        String thePath = this.buildPath();
        this._rtfPath.setText(thePath);
        if (thePath == null) {
            this.updateList(thePath);
        } else if (!thePath.equals("*?*")) {
            this.updateList(thePath);
        } else {
            String strFile = this._currentPath.substring(this._currentPath.lastIndexOf(47) + 1);
            strFile = strFile.substring(0, strFile.lastIndexOf(46));
            this._bef.setText(strFile);
        }
    }

    private void updateList(String path) {
        Vector fileList = this.readFiles(path);
        Object[] fileArray = this.vectorToArray(fileList);
        this._olf.set(fileArray);
    }

    private String buildPath() {
        String newPath = (String)this._olf.get((ListField)this._olf, this._olf.getSelectedIndex());
        if (newPath.equals("..")) {
            newPath = this._currentPath.substring(0, this._currentPath.length() - 2);
            int lastSlash = newPath.lastIndexOf(47);
            newPath = lastSlash == -1 ? null : newPath.substring(0, lastSlash + 1);
        } else if (newPath.lastIndexOf(47) == newPath.length() - 1) {
            if (this._currentPath != null) {
                newPath = String.valueOf(this._currentPath) + newPath;
            }
        } else {
            this._currentPath = String.valueOf(this._currentPath) + newPath;
            newPath = "*?*";
        }
        return newPath;
    }

    private Object[] vectorToArray(Vector filesVector) {
        Object[] files;
        int dotIncrementor;
        int filesCount = filesVector.size();
        if (this._currentPath == null) {
            dotIncrementor = 0;
            files = new Object[filesCount];
        } else {
            dotIncrementor = 1;
            files = new Object[filesCount + dotIncrementor];
            files[0] = "..";
        }
        int count = 0;
        while (count < filesCount) {
            files[count + dotIncrementor] = filesVector.elementAt(count);
            ++count;
        }
        return files;
    }

    protected boolean navigationClick(int status, int time) {
        this.doSelection();
        return true;
    }

    protected boolean keyChar(char c, int status, int time) {
        if (c == '\u001b') {
            this._currentPath = null;
            this.close();
            return true;
        }
        if (c == '\n') {
            this.doSelection();
            return true;
        }
        return super.keyChar(c, status, time);
    }
}

