/*
 * Decompiled with CFR 0.152.
 */
package com.futronictech.fs28;

public class MyBitmapFile {
    private BITMAPFILEHEADER m_fileHeaderBitmap = new BITMAPFILEHEADER();
    private BITMAPINFO m_infoBitmap = new BITMAPINFO();
    private byte[] m_BmpData;

    public MyBitmapFile() {
    }

    public MyBitmapFile(int nWidth, int nHeight, byte[] pImage) {
        int length;
        this.m_fileHeaderBitmap.bfSize = length = this.m_fileHeaderBitmap.sizeof() + this.m_infoBitmap.sizeof() + nWidth * nHeight;
        this.m_fileHeaderBitmap.bfOffBits = this.m_fileHeaderBitmap.sizeof() + this.m_infoBitmap.sizeof();
        this.m_infoBitmap.bmiHeader.biWidth = nWidth;
        this.m_infoBitmap.bmiHeader.biHeight = nHeight;
        this.m_BmpData = new byte[length];
        byte[] TempData = this.m_fileHeaderBitmap.toBytes();
        System.arraycopy(TempData, 0, this.m_BmpData, 0, TempData.length);
        int offset = TempData.length;
        TempData = this.m_infoBitmap.bmiHeader.toBytes();
        System.arraycopy(TempData, 0, this.m_BmpData, offset, TempData.length);
        offset += TempData.length;
        TempData = this.m_infoBitmap.bmiColors.GetGRBTableByteData();
        System.arraycopy(TempData, 0, this.m_BmpData, offset, TempData.length);
        offset += TempData.length;
        byte[] pRotateImage = new byte[nWidth * nHeight];
        int nImgOffset = 0;
        int iCyc = 0;
        while (iCyc < nHeight) {
            System.arraycopy(pImage, (nHeight - iCyc - 1) * nWidth, pRotateImage, nImgOffset, nWidth);
            nImgOffset += nWidth;
            ++iCyc;
        }
        System.arraycopy(pRotateImage, 0, this.m_BmpData, offset, nWidth * nHeight);
        pRotateImage = null;
        TempData = null;
    }

    public byte[] toBytes() {
        return this.m_BmpData;
    }

    public class BITMAPFILEHEADER {
        public short bfType = (short)19778;
        public int bfSize;
        public short bfReserved1 = 0;
        public short bfReserved2 = 0;
        public int bfOffBits;

        public int sizeof() {
            return 14;
        }

        public byte[] toBytes() {
            byte[] m_Data = new byte[14];
            byte[] bytes = convet2bytes.short2bytes(this.bfType);
            System.arraycopy(bytes, 0, m_Data, 0, 2);
            bytes = convet2bytes.int2bytes(this.bfSize);
            System.arraycopy(bytes, 0, m_Data, 2, 4);
            bytes = convet2bytes.short2bytes(this.bfReserved1);
            System.arraycopy(bytes, 0, m_Data, 6, 2);
            bytes = convet2bytes.short2bytes(this.bfReserved2);
            System.arraycopy(bytes, 0, m_Data, 8, 2);
            bytes = convet2bytes.int2bytes(this.bfOffBits);
            System.arraycopy(bytes, 0, m_Data, 10, 4);
            return m_Data;
        }
    }

    public class BITMAPINFO {
        public BITMAPINFOHEADER bmiHeader;
        public RGBQUAD bmiColors;

        public BITMAPINFO() {
            this.bmiHeader = new BITMAPINFOHEADER();
            this.bmiColors = new RGBQUAD();
        }

        public int sizeof() {
            return this.bmiHeader.biSize + 1024;
        }
    }

    public class BITMAPINFOHEADER {
        public int biSize = 40;
        public int biWidth;
        public int biHeight;
        public short biPlanes = 1;
        public short biBitCount = (short)8;
        public int biCompression = 0;
        public int biSizeImage = 0;
        public int biXPelsPerMeter = 19686;
        public int biYPelsPerMeter = 19686;
        public int biClrUsed = 0;
        public int biClrImportant = 0;

        public byte[] toBytes() {
            byte[] m_Data = new byte[40];
            byte[] bytes = convet2bytes.int2bytes(this.biSize);
            System.arraycopy(bytes, 0, m_Data, 0, 4);
            bytes = convet2bytes.int2bytes(this.biWidth);
            System.arraycopy(bytes, 0, m_Data, 4, 4);
            bytes = convet2bytes.int2bytes(this.biHeight);
            System.arraycopy(bytes, 0, m_Data, 8, 4);
            bytes = convet2bytes.short2bytes(this.biPlanes);
            System.arraycopy(bytes, 0, m_Data, 12, 2);
            bytes = convet2bytes.short2bytes(this.biBitCount);
            System.arraycopy(bytes, 0, m_Data, 14, 2);
            bytes = convet2bytes.int2bytes(this.biCompression);
            System.arraycopy(bytes, 0, m_Data, 16, 4);
            bytes = convet2bytes.int2bytes(this.biSizeImage);
            System.arraycopy(bytes, 0, m_Data, 20, 4);
            bytes = convet2bytes.int2bytes(this.biXPelsPerMeter);
            System.arraycopy(bytes, 0, m_Data, 24, 4);
            bytes = convet2bytes.int2bytes(this.biYPelsPerMeter);
            System.arraycopy(bytes, 0, m_Data, 28, 4);
            bytes = convet2bytes.int2bytes(this.biClrUsed);
            System.arraycopy(bytes, 0, m_Data, 32, 4);
            bytes = convet2bytes.int2bytes(this.biClrImportant);
            System.arraycopy(bytes, 0, m_Data, 36, 4);
            return m_Data;
        }
    }

    public class RGBQUAD {
        public byte rgbBlue;
        public byte rgbGreen;
        public byte rgbRed;
        public byte rgbReserved = 0;

        public byte[] GetGRBTableByteData() {
            byte[] m_Data = new byte[1024];
            int nOffset = 0;
            int i = 0;
            while (i < 256) {
                m_Data[nOffset] = (byte)i;
                m_Data[nOffset + 1] = (byte)i;
                m_Data[nOffset + 2] = (byte)i;
                m_Data[nOffset + 3] = (byte)i;
                nOffset += 4;
                ++i;
            }
            return m_Data;
        }
    }

    public static class convet2bytes {
        public static byte[] short2bytes(short s) {
            byte[] ret = new byte[]{(byte)(s & 0xFF), (byte)((s & 0xFF00) >> 8)};
            return ret;
        }

        public static byte[] int2bytes(int i) {
            byte[] ret = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8), (byte)((i & 0xFF0000) >> 16), (byte)((i & 0xFF000000) >> 24)};
            return ret;
        }
    }
}

