/*
 * Decompiled with CFR 0.152.
 */
package com.futronictech.fs28;

import com.futronictech.fs28.FS28Demo;
import com.futronictech.fs28.FileSelectorPopupScreen;
import com.futronictech.fs28.MyBitmapFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.rim.device.api.bluetooth.BluetoothSerialPort;
import net.rim.device.api.bluetooth.BluetoothSerialPortInfo;
import net.rim.device.api.bluetooth.BluetoothSerialPortListener;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.Status;
import net.rim.device.api.ui.container.MainScreen;
import net.rim.device.api.util.Arrays;
import net.rim.device.api.util.DataBuffer;

public class SPPScreen
extends MainScreen
implements BluetoothSerialPortListener {
    public static final int DATA_TYPE_RAWIMAGE = 0;
    public static final int DATA_TYPE_WSQIMAGE = 1;
    public static final int DATA_TYPE_SAMPLE = 2;
    public static final int TIMEOUT_RAW = 20000;
    public static final int TIMEOUT_OTHERS = 3000;
    private byte[] _receiveBuffer = new byte[2048];
    private BluetoothSerialPort _port;
    private static boolean _dataSent = true;
    private String _deviceName;
    private DataBuffer _db;
    private LabelField _lblMessage;
    private BitmapField _bmpFP;
    private byte[] mCommand = new byte[13];
    private int mCommandLength = 0;
    private long mTimeDownloadImage = 0L;
    private int mDataType = 0;
    private int mbytesRead = 0;
    private int mbytesTotal = 153602;
    private int mbytesTotalRead = 0;
    private byte[] mImageBuffer = new byte[153602];
    private MyBitmapFile mFileBmp = null;
    private int mWSQDataSize = 0;
    private boolean mDataMode = false;
    private boolean mDataReceived = false;
    private String mErrorMessage = null;
    private byte[] mHostSample = new byte[669];
    private Timer mTimer = null;
    private TimerTask mTimerTask = null;
    private MenuItem _closeSP = new MenuItem("Close connection", 20, 20){

        public void run() {
            SPPScreen.this.close();
        }
    };
    private MenuItem _saveFile = new MenuItem("Save file", 20, 20){

        public void run() {
            if (!SPPScreen.this.mDataReceived) {
                return;
            }
            SPPScreen.this.saveFile();
        }
    };

    public SPPScreen(BluetoothSerialPortInfo info) {
        Arrays.fill((byte[])this._receiveBuffer, (byte)0);
        this._db = new DataBuffer();
        this._lblMessage = new LabelField((Object)"", 0x1000000000000000L);
        this.add((Field)this._lblMessage);
        Bitmap bitmapImage = Bitmap.getBitmapResource((String)"logo.png");
        this._bmpFP = new BitmapField(bitmapImage);
        this.add((Field)this._bmpFP);
        try {
            if (info == null) {
                this._port = new BluetoothSerialPort("Hi there", 7, 3, 0, 2048, 2048, (BluetoothSerialPortListener)this);
                this._lblMessage.setText((Object)"Waiting for connections...");
                this._deviceName = "unknown";
            } else {
                this._port = new BluetoothSerialPort(info, 7, 3, 0, 2048, 2048, (BluetoothSerialPortListener)this);
                this._deviceName = info.getDeviceName();
            }
        }
        catch (IOException ex) {
            FS28Demo.errorDialog(ex.toString());
        }
        this.addMenuItem(this._saveFile);
        this.addMenuItem(this._closeSP);
        this.mTimer = new Timer();
    }

    public void deviceConnected(boolean success) {
        if (success) {
            Status.show((String)"Bluetooth SPP connected");
            this._lblMessage.setText((Object)"Connected");
        } else {
            Status.show((String)"Bluetooth SPP failed to connect");
            this._lblMessage.setText((Object)"Failed to connect");
        }
    }

    public void deviceDisconnected() {
        Status.show((String)("Disconnected from " + this._deviceName));
    }

    public void dtrStateChange(boolean high) {
    }

    public void dataReceived(int length) {
        if (!this.mDataMode) {
            if (length > 13) {
                return;
            }
            try {
                this.mbytesRead = this._port.read(this._receiveBuffer, 0, length == -1 ? 13 : length);
                if (this.mbytesRead <= 0) {
                    return;
                }
            }
            catch (IOException ioex) {
                FS28Demo.errorDialog(ioex.toString());
                return;
            }
            System.arraycopy(this._receiveBuffer, 0, this.mCommand, this.mCommandLength, this.mbytesRead);
            this.mCommandLength += this.mbytesRead;
            if (this.mCommandLength == 13) {
                this.mbytesTotalRead = 0;
                this.mCommandLength = 0;
                int[] Size = new int[1];
                if (!this.validateCommandData(this.mCommand, Size)) {
                    this.responseToFS28((byte)0, (byte)65);
                    FS28Demo.errorDialog(this.mErrorMessage);
                    return;
                }
                switch (this.mCommand[1]) {
                    case 54: {
                        this.responseToFS28((byte)0, (byte)64);
                        this._lblMessage.setText((Object)"Got convert WSQ cmd");
                        return;
                    }
                    case 15: {
                        this.responseToFS28((byte)0, (byte)64);
                        this.mbytesTotal = Size[0];
                        this.mWSQDataSize = this.mbytesTotal - 2;
                        this._lblMessage.setText((Object)"Downloading WSQ image");
                        this.mDataType = 1;
                        this.mTimeDownloadImage = System.currentTimeMillis();
                        this.startTimer(3000);
                        break;
                    }
                    case 68: {
                        this.responseToFS28((byte)0, (byte)64);
                        this.mbytesTotal = 153602;
                        this.mDataType = 0;
                        this._lblMessage.setText((Object)"Downloading RAW image");
                        this.mTimeDownloadImage = System.currentTimeMillis();
                        this.startTimer(20000);
                        break;
                    }
                    case 77: {
                        this.responseToFS28((byte)0, (byte)64);
                        this.mDataType = 2;
                        this.mbytesTotal = 666;
                        this._lblMessage.setText((Object)"Downloading Sample data");
                        this.mTimeDownloadImage = System.currentTimeMillis();
                        this.startTimer(3000);
                        break;
                    }
                    default: {
                        this._lblMessage.setText((Object)"Unknown command");
                        this.responseToFS28((byte)0, (byte)65);
                        return;
                    }
                }
                if (this.mbytesTotal > 153602) {
                    this._lblMessage.setText((Object)("Data size is too large! - " + this.mbytesTotal));
                    this.responseToFS28((byte)0, (byte)65);
                    return;
                }
                this.mDataMode = true;
                this.mDataReceived = false;
                return;
            }
            return;
        }
        if (length > this._receiveBuffer.length) {
            length = this._receiveBuffer.length;
        }
        try {
            this.mbytesRead = this._port.read(this._receiveBuffer, 0, length == -1 ? this._receiveBuffer.length : length);
            if (this.mbytesRead <= 0) {
                return;
            }
        }
        catch (IOException ioex) {
            FS28Demo.errorDialog(ioex.toString());
            return;
        }
        System.arraycopy(this._receiveBuffer, 0, this.mImageBuffer, this.mbytesTotalRead, this.mbytesRead);
        this.mbytesTotalRead += this.mbytesRead;
        this._lblMessage.setText((Object)("Downloading ...... " + this.mbytesTotalRead * 100 / this.mbytesTotal + "%"));
        if (this.mbytesTotalRead >= this.mbytesTotal) {
            this.stopTimer();
            this.responseToFS28((byte)0, (byte)64);
            this.enterCommandMode();
            this.mDataReceived = true;
            String strMsg = null;
            if (this.mDataType == 0) {
                strMsg = "RAW image downloaded! Time: ";
            } else if (this.mDataType == 1) {
                strMsg = "WSQ image downloaded! Time: ";
            } else if (this.mDataType == 2) {
                strMsg = "Sample downloaded! Time: ";
            }
            this._lblMessage.setText((Object)(String.valueOf(strMsg) + (System.currentTimeMillis() - this.mTimeDownloadImage) + "ms"));
            this.showBitmap();
        }
    }

    public void dataSent() {
        _dataSent = true;
        this.sendData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(byte[] theData, int offset, int length) {
        DataBuffer dataBuffer = this._db;
        synchronized (dataBuffer) {
            this._db.write(theData, offset, length);
            this.sendData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData() {
        if (this._db.getArrayLength() > 0) {
            if (_dataSent) {
                try {
                    _dataSent = false;
                    DataBuffer dataBuffer = this._db;
                    synchronized (dataBuffer) {
                        this._port.write(this._db.getArray(), 0, this._db.getArrayLength());
                        this._db.reset();
                    }
                }
                catch (IOException ioex) {
                    _dataSent = true;
                    FS28Demo.errorDialog("Failed to write data: " + ioex.toString());
                }
            } else {
                System.out.println("Can't send data right now, data will be sent after dataSent notify call.");
            }
        }
    }

    public void close() {
        if (this._port != null) {
            this._port.close();
        }
        super.close();
    }

    public boolean validateCommandData(byte[] Command, int[] Size) {
        if (Command.length != 13 || Command[0] != 64 || Command[12] != 13) {
            this.mErrorMessage = "Invalid command data!";
            return false;
        }
        int checksum = 0;
        int i = 0;
        while (i < 11) {
            checksum += Command[i];
            ++i;
        }
        if (Command[11] != (byte)checksum) {
            this.mErrorMessage = "Checksum error!";
            return false;
        }
        checksum = 0;
        i = 9;
        while (i > 5) {
            short unsignedByte = Command[i] < 0 ? (short)(256 + Command[i]) : Command[i];
            checksum |= unsignedByte;
            if (i > 6) {
                checksum *= 256;
            }
            --i;
        }
        Size[0] = checksum + 2;
        return true;
    }

    public void ConvertToHostSample(byte[] FamSample) {
        this.mHostSample[0] = -99;
        this.mHostSample[1] = 2;
        this.mHostSample[2] = 2;
        this.mHostSample[3] = 2;
        this.mHostSample[4] = 0;
        System.arraycopy(FamSample, 0, this.mHostSample, 5, 664);
    }

    private void startTimer(int timeout) {
        this.mTimerTask = new TimerTask(){

            public void run() {
                SPPScreen.this.responseToFS28((byte)0, (byte)65);
                SPPScreen.this.enterCommandMode();
                FS28Demo.errorDialog("Timeout to receive data!\nPlease close the connection and connect again!");
            }
        };
        this.mTimer.schedule(this.mTimerTask, timeout);
    }

    private void stopTimer() {
        this.mTimerTask.cancel();
    }

    private void responseToFS28(byte command, byte flag) {
        byte[] byArray = new byte[13];
        byArray[0] = 64;
        byArray[12] = 13;
        byte[] Response = byArray;
        byte checksum = 0;
        Response[1] = command;
        Response[10] = flag;
        int i = 0;
        while (i < 11) {
            checksum = (byte)(checksum + Response[i]);
            ++i;
        }
        Response[11] = checksum;
        this.writeData(Response, 0, 13);
    }

    private void enterCommandMode() {
        this.mCommandLength = 0;
        this.mbytesRead = 0;
        this.mbytesTotalRead = 0;
        this.mDataMode = false;
        this.mbytesTotal = 153602;
    }

    private void showBitmap() {
        if (this.mDataType != 0) {
            this._bmpFP.setBitmap(null);
            return;
        }
        this.mFileBmp = new MyBitmapFile(320, 480, this.mImageBuffer);
        Bitmap bmp = Bitmap.createBitmapFromBytes((byte[])this.mFileBmp.toBytes(), (int)0, (int)-1, (int)1);
        this._bmpFP.setBitmap(bmp);
    }

    private void saveFile() {
        String strExtension = null;
        if (this.mDataType == 0) {
            strExtension = "bmp";
        } else if (this.mDataType == 1) {
            strExtension = "wsq";
        } else if (this.mDataType == 2) {
            strExtension = "bin";
        }
        FileSelectorPopupScreen fps = new FileSelectorPopupScreen(null, strExtension);
        fps.pickFile();
        String theFile = fps.getFile();
        if (theFile != null) {
            try {
                FileConnection fc = (FileConnection)Connector.open((String)theFile, (int)3);
                if (!fc.exists()) {
                    fc.create();
                }
                OutputStream outStream = fc.openOutputStream();
                if (this.mDataType == 0) {
                    if (this.mFileBmp != null) {
                        outStream.write(this.mFileBmp.toBytes());
                    }
                } else if (this.mDataType == 1) {
                    if (this.mWSQDataSize > 0) {
                        outStream.write(this.mImageBuffer, 0, this.mWSQDataSize);
                    }
                } else if (this.mDataType == 2) {
                    this.ConvertToHostSample(this.mImageBuffer);
                    outStream.write(this.mHostSample);
                }
                outStream.close();
                fc.close();
                this._lblMessage.setText((Object)("File is saved to " + theFile));
            }
            catch (Exception ex) {
                Dialog.alert((String)("Unable to save file. " + ex.toString()));
            }
        }
    }
}

