// DlgEnroll.cpp : implementation file
//

#include "stdafx.h"
#include "EthFamEx.h"
#include "DlgEnroll.h"


// CDlgEnroll dialog

IMPLEMENT_DYNAMIC(CDlgEnroll, CDialog)

CDlgEnroll::CDlgEnroll(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgEnroll::IDD, pParent)
	, m_nGroupID(0)
	, m_nUID(0)
{

}

CDlgEnroll::~CDlgEnroll()
{
}

void CDlgEnroll::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_UID, m_ctrlUID);
	DDX_Control(pDX, IDC_COMBO_UTYPE, m_ctrlUType);
	DDX_Control(pDX, IDC_COMBO_SL, m_ctrlSL);
	DDX_Text(pDX, IDC_EDIT_GID, m_nGroupID);
	DDX_Control(pDX, IDC_COMBO_FINGERID, m_cboFingerID);
	DDX_Text(pDX, IDC_EDIT_UID, m_nUID);
}


BEGIN_MESSAGE_MAP(CDlgEnroll, CDialog)
	ON_BN_CLICKED(IDOK, &CDlgEnroll::OnBnClickedOk)
END_MESSAGE_MAP()


// CDlgEnroll message handlers

BOOL CDlgEnroll::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_nUID = 0;
	m_nUType = 0;
	
	m_ctrlUID.LimitText(16);

	m_ctrlUType.AddString(_T("VIP"));
	m_ctrlUType.AddString(_T("Ordinary"));
	m_ctrlUType.SetCurSel(0);

	m_ctrlSL.AddString(_T("0"));
	m_ctrlSL.AddString(_T("1"));
	m_ctrlSL.AddString(_T("2"));
	m_ctrlSL.AddString(_T("3"));
	m_ctrlSL.SetCurSel(2);

	m_cboFingerID.AddString(_T("0 - LF5"));
	m_cboFingerID.AddString(_T("1 - LF4"));
	m_cboFingerID.AddString(_T("2 - LF3"));
	m_cboFingerID.AddString(_T("3 - LF2"));
	m_cboFingerID.AddString(_T("4 - LF1"));
	m_cboFingerID.AddString(_T("5 - RF1"));
	m_cboFingerID.AddString(_T("6 - RF2"));
	m_cboFingerID.AddString(_T("7 - RF3"));
	m_cboFingerID.AddString(_T("8 - RF4"));
	m_cboFingerID.AddString(_T("9 - RF5"));
	m_cboFingerID.SetCurSel(6);

	return TRUE;
}


void CDlgEnroll::OnBnClickedOk()
{
	UpdateData(1);
	CString strTemp;
	m_ctrlUID.GetWindowTextW( strTemp );
	if( strTemp.IsEmpty() )
	{
		MessageBox(_T("User ID could not be empty."), 0, MB_OK|MB_ICONSTOP);
		return;
	}

	if( m_nUID > 0xFFFFFFFFFFFF )	//maximum 6bytes User ID
	{
		MessageBox(_T("User ID could not larger than 0xffffffffffff!"), 0, MB_OK|MB_ICONSTOP);
		return;
	}

	int nIndex = m_cboFingerID.GetCurSel();
	m_cboFingerID.GetLBText(nIndex, strTemp);
	m_nFingerID = _wtoi(strTemp);

	nIndex = m_ctrlSL.GetCurSel();
	m_ctrlSL.GetLBText(nIndex, strTemp);
	m_nUType = _wtoi(strTemp);

	nIndex = m_ctrlUType.GetCurSel();
	m_ctrlUType.GetLBText(nIndex, strTemp);
	if( strTemp.Compare(_T("VIP")) == 0 )
		m_nUType += 0x04;
	
	OnOK();
}
