// DlgNetwork.cpp : implementation file
//

#include "stdafx.h"
#include "EthFamEx.h"
#include "DlgNetwork.h"


// CDlgNetwork dialog

IMPLEMENT_DYNAMIC(CDlgNetwork, CDialog)

CDlgNetwork::CDlgNetwork(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgNetwork::IDD, pParent)
	, m_dwIP(0)
	, m_dwGW(0)
	, m_strM1(_T(""))
	, m_strM2(_T(""))
	, m_strM3(_T(""))
	, m_strM4(_T(""))
	, m_strM5(_T(""))
	, m_strM6(_T(""))
	, m_nPort(0)
	, m_dwSM(0)
{

}

CDlgNetwork::~CDlgNetwork()
{
}

void CDlgNetwork::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_IPAddress(pDX, IDC_IPADDRESS1, m_dwIP);
	DDX_IPAddress(pDX, IDC_IPADDRESS2, m_dwGW);
	DDX_Text(pDX, IDC_EDIT_MAC1, m_strM1);
	DDX_Text(pDX, IDC_EDIT_MAC2, m_strM2);
	DDX_Text(pDX, IDC_EDIT_MAC3, m_strM3);
	DDX_Text(pDX, IDC_EDIT_MAC4, m_strM4);
	DDX_Text(pDX, IDC_EDIT_MAC5, m_strM5);
	DDX_Text(pDX, IDC_EDIT_MAC6, m_strM6);
	DDX_Text(pDX, IDC_EDIT_PORT, m_nPort);
	DDX_Control(pDX, IDC_EDIT_PORT, m_ctrlPort);
	DDX_Control(pDX, IDC_EDIT_MAC4, m_ctrlM4);
	DDX_Control(pDX, IDC_EDIT_MAC5, m_ctrlM5);
	DDX_Control(pDX, IDC_EDIT_MAC6, m_ctrlM6);
	DDX_IPAddress(pDX, IDC_IPADDRESS3, m_dwSM);
}


BEGIN_MESSAGE_MAP(CDlgNetwork, CDialog)
	ON_EN_CHANGE(IDC_EDIT_MAC4, &CDlgNetwork::OnEnChangeEditMac4)
	ON_EN_KILLFOCUS(IDC_EDIT_MAC4, &CDlgNetwork::OnEnKillfocusEditMac4)
	ON_EN_CHANGE(IDC_EDIT_MAC5, &CDlgNetwork::OnEnChangeEditMac5)
	ON_EN_KILLFOCUS(IDC_EDIT_MAC5, &CDlgNetwork::OnEnKillfocusEditMac5)
	ON_EN_CHANGE(IDC_EDIT_MAC6, &CDlgNetwork::OnEnChangeEditMac6)
	ON_EN_KILLFOCUS(IDC_EDIT_MAC6, &CDlgNetwork::OnEnKillfocusEditMac6)
	ON_BN_CLICKED(IDOK, &CDlgNetwork::OnBnClickedOk)
END_MESSAGE_MAP()


// CDlgNetwork message handlers
BOOL CDlgNetwork::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_ctrlPort.SetLimitText(5);
	m_ctrlM4.SetLimitText(2);
	m_ctrlM5.SetLimitText(2);
	m_ctrlM6.SetLimitText(2);

	m_dwIP_old = m_dwIP;

	UpdateData(0);

	return TRUE;
}

bool CDlgNetwork::CheckValidNumber( LPCTSTR strMac )
{
	if( strMac[0] != 0 )
	{
		if( strMac[0] < '0' || strMac[0] > 'F' )
			return false;

		if( strMac[0] > '9' && strMac[0] < 'A' )
			return false;
	}
	if( strMac[1] != 0 )
	{
		if( strMac[1] < '0' || strMac[1] > 'F' )
			return false;

		if( strMac[1] > '9' && strMac[1] < 'A' )
			return false;
	}
	return true;
}


void CDlgNetwork::OnEnChangeEditMac4()
{
	CString strTmp = m_strM4;
	UpdateData(1);
	if( !CheckValidNumber( (LPCTSTR)m_strM4 ) )
	{
		MessageBox(_T("MAC address must be in range '0-F'"), 0, MB_OK|MB_ICONSTOP);
		m_strM4 = strTmp;
		UpdateData(0);
	}
}

void CDlgNetwork::OnEnKillfocusEditMac4()
{
	UpdateData(1);
	if( m_strM4.GetLength() < 2 )
	{
		if( m_strM4.GetLength() == 0 )
			m_strM4 = _T("00");
		else if( m_strM4.GetLength() == 1 )
			m_strM4 = _T("0") + m_strM4 ;
		UpdateData(0);
	}
}


void CDlgNetwork::OnEnChangeEditMac5()
{
	CString strTmp = m_strM5;
	UpdateData(1);
	if( !CheckValidNumber( (LPCTSTR)m_strM5 ) )
	{
		MessageBox(_T("MAC address must be in range '0-F'"), 0, MB_OK|MB_ICONSTOP);
		m_strM5 = strTmp;
		UpdateData(0);
	}
}

void CDlgNetwork::OnEnKillfocusEditMac5()
{
	UpdateData(1);
	if( m_strM5.GetLength() < 2 )
	{
		if( m_strM5.GetLength() == 0 )
			m_strM5 = _T("00");
		else if( m_strM5.GetLength() == 1 )
			m_strM5 = _T("0") + m_strM5 ;
		UpdateData(0);
	}
}

void CDlgNetwork::OnEnChangeEditMac6()
{
	CString strTmp = m_strM6;
	UpdateData(1);
	if( !CheckValidNumber( (LPCTSTR)m_strM6 ) )
	{
		MessageBox(_T("MAC address must be in range '0-F'"), 0, MB_OK|MB_ICONSTOP);
		m_strM6 = strTmp;
		UpdateData(0);
	}
}

void CDlgNetwork::OnEnKillfocusEditMac6()
{
	UpdateData(1);
	if( m_strM6.GetLength() < 2 )
	{
		if( m_strM6.GetLength() == 0 )
			m_strM6 = _T("00");
		else if( m_strM6.GetLength() == 1 )
			m_strM6 = _T("0") + m_strM6 ;
		UpdateData(0);
	}
}

void CDlgNetwork::OnBnClickedOk()
{
	UpdateData(1);
	if( m_nPort == 0 || m_nPort > 65535 )
	{
		MessageBox( _T("Port number must be in the range of 1-65535!"), 0, MB_OK|MB_ICONSTOP );
		return;
	}
	if( m_dwIP_old != m_dwIP )
	{
		int nRet;
		nRet = MessageBox( _T("Please keep record for the changed IP address and press YES to confirm.\n\nAfter it is changed, there is no way to reset it by ethernet connection!\n\nAre you sure to change the IP address?\n\n"), 0, MB_YESNO|MB_ICONQUESTION );
		if( nRet == IDYES )
		{
			OnOK();
			return;
		}
		return;
	}
	OnOK();
}
