// DlgPeripheral.cpp : implementation file
//

#include "stdafx.h"
#include "EthFamEx.h"
#include "DlgPeripheral.h"

extern CFamComm commFam;

// CDlgPeripheral dialog

IMPLEMENT_DYNAMIC(CDlgPeripheral, CDialog)

CDlgPeripheral::CDlgPeripheral(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgPeripheral::IDD, pParent)
{
	m_uiParam1 = m_uiParam2 = 0;
}

CDlgPeripheral::~CDlgPeripheral()
{
}

BOOL CDlgPeripheral::OnInitDialog()
{
	CDialog::OnInitDialog();

	commFam.SetCommandWindowHandle( m_editCommandList.m_hWnd );
	commFam.SetMessageWindowHandle( NULL );
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDlgPeripheral::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_COMMANDLIST, m_editCommandList);
	DDX_Control(pDX, IDC_LBL_SENSOR_1, m_lblSensor1);
	DDX_Control(pDX, IDC_LBL_SENSOR_2, m_lblSensor2);
}


BEGIN_MESSAGE_MAP(CDlgPeripheral, CDialog)
	ON_BN_CLICKED(IDC_RADIO_LED1_ON, &CDlgPeripheral::OnBnClickedRadioLed1On)
	ON_BN_CLICKED(IDC_RADIO_LED1_OFF, &CDlgPeripheral::OnBnClickedRadioLed1Off)
	ON_BN_CLICKED(IDC_RADIO_LED2_ON, &CDlgPeripheral::OnBnClickedRadioLed2On)
	ON_BN_CLICKED(IDC_RADIO_LED2_OFF, &CDlgPeripheral::OnBnClickedRadioLed2Off)
	ON_BN_CLICKED(IDC_RADIO_BUZZER_ON, &CDlgPeripheral::OnBnClickedRadioBuzzerOn)
	ON_BN_CLICKED(IDC_RADIO_BUZZER_OFF, &CDlgPeripheral::OnBnClickedRadioBuzzerOff)
	ON_BN_CLICKED(IDC_RADIO_LOCK_ON, &CDlgPeripheral::OnBnClickedRadioLockOn)
	ON_BN_CLICKED(IDC_RADIO_LOCK_OFF, &CDlgPeripheral::OnBnClickedRadioLockOff)
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CDlgPeripheral message handlers

void CDlgPeripheral::OnBnClickedRadioLed1On()
{
	m_uiParam1 = m_uiParam1 | 0x00000008;
	m_uiParam2 = m_uiParam2 & 0xfffffff7;
	commFam.ResetCountOfCommandList();
	m_nErrorCode = commFam.FamPeripherialControl( m_uiParam1, m_uiParam2, &m_nSensorState);
	if( m_nErrorCode != 0 )
		PrintErrorMessage();
	else
		SetSensorState();
}

void CDlgPeripheral::OnBnClickedRadioLed1Off()
{
	m_uiParam2 = m_uiParam2 | 0x00000008;
	m_uiParam1 = m_uiParam1 & 0xfffffff7;
	commFam.ResetCountOfCommandList();
	m_nErrorCode = commFam.FamPeripherialControl( m_uiParam1, m_uiParam2, &m_nSensorState);
	if( m_nErrorCode != 0 )
		PrintErrorMessage();
	else
		SetSensorState();
}

void CDlgPeripheral::OnBnClickedRadioLed2On()
{
	m_uiParam1 = m_uiParam1 | 0x00000010;
	m_uiParam2 = m_uiParam2 & 0xffffffef;
	commFam.ResetCountOfCommandList();
	m_nErrorCode = commFam.FamPeripherialControl( m_uiParam1, m_uiParam2, &m_nSensorState);
	if( m_nErrorCode != 0 )
		PrintErrorMessage();
	else
		SetSensorState();
}

void CDlgPeripheral::OnBnClickedRadioLed2Off()
{
	m_uiParam2 = m_uiParam2 | 0x00000010;
	m_uiParam1 = m_uiParam1 & 0xffffffef;
	commFam.ResetCountOfCommandList();
	m_nErrorCode = commFam.FamPeripherialControl( m_uiParam1, m_uiParam2, &m_nSensorState);
	if( m_nErrorCode != 0 )
		PrintErrorMessage();
	else
		SetSensorState();
}

void CDlgPeripheral::OnBnClickedRadioBuzzerOn()
{
	m_uiParam1 = m_uiParam1 | 0x00000001;
	m_uiParam2 = m_uiParam2 & 0xfffffffe;
	commFam.ResetCountOfCommandList();
	m_nErrorCode = commFam.FamPeripherialControl( m_uiParam1, m_uiParam2, &m_nSensorState);
	if( m_nErrorCode != 0 )
		PrintErrorMessage();
	else
		SetSensorState();
}

void CDlgPeripheral::OnBnClickedRadioBuzzerOff()
{
	m_uiParam2 = m_uiParam2 | 0x00000001;
	m_uiParam1 = m_uiParam1 & 0xfffffffe;
	commFam.ResetCountOfCommandList();
	m_nErrorCode = commFam.FamPeripherialControl( m_uiParam1, m_uiParam2, &m_nSensorState);
	if( m_nErrorCode != 0 )
		PrintErrorMessage();
	else
		SetSensorState();
}

void CDlgPeripheral::OnBnClickedRadioLockOn()
{
	m_uiParam1 = m_uiParam1 | 0x00000004;
	m_uiParam2 = m_uiParam2 & 0xfffffffb;
	commFam.ResetCountOfCommandList();
	m_nErrorCode = commFam.FamPeripherialControl( m_uiParam1, m_uiParam2, &m_nSensorState);
	if( m_nErrorCode != 0 )
		PrintErrorMessage();
	else
		SetSensorState();
}

void CDlgPeripheral::OnBnClickedRadioLockOff()
{
	m_uiParam2 = m_uiParam2 | 0x00000004;
	m_uiParam1 = m_uiParam1 & 0xfffffffb;
	commFam.ResetCountOfCommandList();
	m_nErrorCode = commFam.FamPeripherialControl( m_uiParam1, m_uiParam2, &m_nSensorState);
	if( m_nErrorCode != 0 )
		PrintErrorMessage();
	else
		SetSensorState();
}

void CDlgPeripheral::PrintErrorMessage( )
{
	CString strErrMsg;
	strErrMsg = commFam.GetErrorMessage();
	m_editCommandList.SetWindowText( strErrMsg );
}

void CDlgPeripheral::OnDestroy()
{
	CDialog::OnDestroy();
	commFam.SetMessageWindowHandle(NULL);
	commFam.SetCommandWindowHandle(NULL);
}

void CDlgPeripheral::SetSensorState()
{
	if( m_nSensorState & 0x01 )
		m_lblSensor1.SetWindowText(_T("Open"));
	else
		m_lblSensor1.SetWindowText(_T("Close"));
	if( m_nSensorState & 0x02 )
		m_lblSensor2.SetWindowText(_T("Open"));
	else
		m_lblSensor2.SetWindowText(_T("Close"));
}