// DlgUserId.cpp : implementation file
//

#include "stdafx.h"
#include "EthFamEx.h"
#include "DlgUserId.h"


// CDlgUserId dialog

IMPLEMENT_DYNAMIC(CDlgUserId, CDialog)

CDlgUserId::CDlgUserId(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgUserId::IDD, pParent)
	, m_strUserId(_T(""))
	, m_nGroupID(0)
{
	m_nID_L = 0;
	m_nID_H = 0;
	m_nUType = 0;
	m_nGroupID = 0;
	m_nFingerID = 6;
	m_bShowUType = FALSE;
}

CDlgUserId::~CDlgUserId()
{
}

void CDlgUserId::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_USERID, m_strUserId);
	DDX_Control(pDX, IDC_LBL_USERTYPE, m_lblUserType);
	DDX_Control(pDX, IDC_COMBO_USERTYPE, m_cboUserType);
	DDX_Control(pDX, IDC_LBL_SL, m_lblSL);
	DDX_Control(pDX, IDC_COMBO_SL, m_cboSL);
	DDX_Text(pDX, IDC_EDIT_GROUPID, m_nGroupID);
	DDX_Control(pDX, IDC_COMBO_FINGERID, m_cboFingerID);
	DDX_Control(pDX, IDC_LBL_STATUS, m_lblStatus);
	DDX_Control(pDX, IDC_COMBO_STATUS, m_cboStatus);
	DDX_Control(pDX, IDC_GB_CHANGE, m_gbChange);
}


BEGIN_MESSAGE_MAP(CDlgUserId, CDialog)
	ON_BN_CLICKED(IDOK, &CDlgUserId::OnBnClickedOk)
END_MESSAGE_MAP()


// CDlgUserId message handlers

BOOL CDlgUserId::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_cboUserType.AddString(_T("VIP"));
	m_cboUserType.AddString(_T("Ordinary"));
	m_cboUserType.SetCurSel(0);
	//
	m_cboSL.AddString(_T("0"));
	m_cboSL.AddString(_T("1"));
	m_cboSL.AddString(_T("2"));
	m_cboSL.AddString(_T("3"));
	m_cboSL.SetCurSel(2);
	//
	m_cboStatus.AddString(_T("Active"));
	m_cboStatus.AddString(_T("Suspend"));
	m_cboStatus.SetCurSel(0);
	//
	m_cboFingerID.AddString(_T("0 - LF5"));
	m_cboFingerID.AddString(_T("1 - LF4"));
	m_cboFingerID.AddString(_T("2 - LF3"));
	m_cboFingerID.AddString(_T("3 - LF2"));
	m_cboFingerID.AddString(_T("4 - LF1"));
	m_cboFingerID.AddString(_T("5 - RF1"));
	m_cboFingerID.AddString(_T("6 - RF2"));
	m_cboFingerID.AddString(_T("7 - RF3"));
	m_cboFingerID.AddString(_T("8 - RF4"));
	m_cboFingerID.AddString(_T("9 - RF5"));
	m_cboFingerID.SetCurSel(6);
	//
	if( m_bShowUType )
	{
		m_lblUserType.ShowWindow(SW_SHOW);
		m_cboUserType.ShowWindow(SW_SHOW);
		m_lblSL.ShowWindow(SW_SHOW);
		m_cboSL.ShowWindow(SW_SHOW);
		m_lblStatus.ShowWindow(SW_SHOW);
		m_cboStatus.ShowWindow(SW_SHOW);
		m_gbChange.ShowWindow(SW_SHOW);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDlgUserId::OnBnClickedOk()
{
	UpdateData(1);
	if( m_strUserId.IsEmpty() )
	{
		MessageBox(_T("Please input the User ID!"), _T("Error"), MB_OK|MB_ICONSTOP);
		return;
	}
	unsigned __int64 ui64UID = _wtoi64( (LPCTSTR)m_strUserId );
	m_nID_L = (UINT) ui64UID;
	m_nID_H = (UINT) (ui64UID / 0x100000000);
	//finger id
	CString strTemp;
	int nIndex = m_cboFingerID.GetCurSel();
	m_cboFingerID.GetLBText(nIndex, strTemp);
	m_nFingerID = (BYTE)_wtoi(strTemp);
	//
	if( m_bShowUType )	
	{
		nIndex = m_cboSL.GetCurSel();
		m_cboSL.GetLBText(nIndex, strTemp);
		m_nUType = _wtoi(strTemp);

		nIndex = m_cboUserType.GetCurSel();
		m_cboUserType.GetLBText(nIndex, strTemp);
		if( strTemp.Compare(_T("VIP")) == 0 )
			m_nUType += 0x04;

		nIndex = m_cboStatus.GetCurSel();
		m_cboStatus.GetLBText(nIndex, strTemp);
		if( strTemp.Compare(_T("Suspend")) == 0 )
			m_nUType += 0x08;
	}

	OnOK();
}
