// EthFamExDlg.cpp : implementation file
//
/*******************************************************************************
// version 2.1
// for PC Com port, the maximum baudrate is 115200bps.
// for USB to UART bridge controller, the maximum baudrate is 921600.
********************************************************************************/

#include "stdafx.h"
#include "EthFamEx.h"
#include "EthFamExDlg.h"
#include "DlgUserList.h"
#include "DlgEnroll.h"
#include "DlgNetwork.h"
#include "DlgOthers.h"
#include "DlgPeripheral.h"
#include "DlgUserId.h"
#include "FamSerialComm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BYTE CFamSerialComm::m_nNumComPort = 0;
TCHAR CFamSerialComm::m_arrEnumComPort[20][128];
// CAboutDlg dialog used for App About
CFamComm commFam;

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CEthFamExDlg dialog


CEthFamExDlg::CEthFamExDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEthFamExDlg::IDD, pParent)
	, m_dwIP(0)
	, m_nPort(0)
	, m_strMessage(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_nInterface = 0;
	m_pImage = NULL;
	GetModuleFileName( NULL, m_pszInitFile, 256 );
	*(wcsrchr( m_pszInitFile, '\\' ) + 1) = '\000';
	wcscat_s( m_pszInitFile, 256, _T("settings.bin") );
	m_strSelectedComPort.Empty();
	ZeroMemory( m_pszSelectedComPort, sizeof(m_pszSelectedComPort) );

	FILE *fptr = NULL;
	_wfopen_s( &fptr, m_pszInitFile, _T("rb") );
	if( fptr != NULL )
	{
		fread( &m_nInterface, 4, 1, fptr );
		fread( m_pszSelectedComPort, sizeof(TCHAR), 10, fptr );
		fclose(fptr);
	}
}

CEthFamExDlg::~CEthFamExDlg()
{
	if( m_pImage != NULL )
		free( m_pImage );

	FILE *fptr = NULL;
	_wfopen_s( &fptr, m_pszInitFile, _T("wb") );
	if( fptr != NULL )
	{
		fwrite( &m_nInterface, 4, 1, fptr );
		wcscpy_s( m_pszSelectedComPort, 10, m_strSelectedComPort );
		fwrite( m_pszSelectedComPort, sizeof(TCHAR), 10, fptr );
		fclose(fptr);
	}
}

void CEthFamExDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_IMAGE, m_ctrlImage);
	DDX_IPAddress(pDX, IDC_IPADDRESS1, m_dwIP);
	DDX_Control(pDX, IDC_EDIT_PORT, m_ctrlPort);
	DDX_Text(pDX, IDC_EDIT_PORT, m_nPort);
	DDX_Control(pDX, IDC_IPADDRESS1, m_ctrlIP);
	DDX_Control(pDX, IDC_PROGRESS1, m_ctrlProgress);
	DDX_Text(pDX, IDC_TXT_MESSAGE, m_strMessage);
	DDX_Control(pDX, IDC_TXT_MESSAGE, m_ctrlMessage);
	DDX_Control(pDX, IDC_BTN_NETWORK, m_btnNetwork);
	DDX_Control(pDX, IDC_BTN_FW, m_btnFW);
	DDX_Control(pDX, IDC_BTN_CAPTURE, m_btnCapture);
	DDX_Control(pDX, IDC_BTN_VERIFY, m_btnVerify);
	DDX_Control(pDX, IDC_BTN_ENROLL, m_btnEnroll);
	DDX_Control(pDX, IDC_BTN_IDENTIFY, m_btnIdentify);
	DDX_Control(pDX, IDC_BTN_CANCEL, m_btnCancel);
	DDX_Control(pDX, IDC_COMBO_MAXSAMPLE, m_ctrlMaxSample);
	DDX_Control(pDX, IDC_BTN_DELETE_SINGLE, m_btnDelete1);
	DDX_Control(pDX, IDC_BTN_DELETE_ALL, m_btnDeleteAll);
	DDX_Control(pDX, IDC_BTN_GET_USER, m_btnGetUser);
	DDX_Control(pDX, IDC_BTN_SEND_USER, m_btnSendUser);
	DDX_Control(pDX, IDOK, m_btnExit);
	DDX_Control(pDX, IDC_BTN_SL, m_btnSL);
	DDX_Control(pDX, IDC_BTN_CHANGE_USER_TYPE, m_btnChangeUser);
	DDX_Control(pDX, IDC_PERIPHERAL, m_btnPeripheral);
	DDX_Control(pDX, IDC_COMBO_COMPORTS, m_cboComPorts);
	DDX_Control(pDX, IDC_COMBO_INTERFACE, m_cboInterface);
	DDX_Control(pDX, IDC_LBL_IPADDRESS, m_lblIPAddress);
	DDX_Control(pDX, IDC_LBL_TCPPORT, m_lblTcpPort);
	DDX_Control(pDX, IDC_LBL_COMPORT, m_lblComPort);
	DDX_Control(pDX, IDC_GBOX_TCP_COM, m_gbTcpCom);
	DDX_Control(pDX, IDC_COMBO_BAUDRATE, m_cboMaxBaudrate);
	DDX_Control(pDX, IDC_BTN_HELP, m_btnHelp);
	DDX_Control(pDX, IDC_LBL_MAX_BAUDRATE, m_lblMaxBaudrate);
	DDX_Control(pDX, IDC_CHECK_SHOWIMAGE, m_chkImage);
	DDX_Control(pDX, IDC_EDIT_COMMANDLIST, m_txtCommandList);
	DDX_Control(pDX, IDC_CHECK_PIV, m_chkPIV);
	DDX_Control(pDX, IDC_CHECK_WSQ, m_chkWsq);
}

BEGIN_MESSAGE_MAP(CEthFamExDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_CAPTURE, &CEthFamExDlg::OnBnClickedBtnCapture)
	ON_BN_CLICKED(IDC_BTN_ENROLL, &CEthFamExDlg::OnBnClickedBtnEnroll)
	ON_BN_CLICKED(IDC_BTN_VERIFY, &CEthFamExDlg::OnBnClickedBtnVerify)
	ON_BN_CLICKED(IDC_BTN_IDENTIFY, &CEthFamExDlg::OnBnClickedBtnIdentify)
	ON_BN_CLICKED(IDC_BTN_FW, &CEthFamExDlg::OnBnClickedBtnFw)
	ON_BN_CLICKED(IDC_BTN_CANCEL, &CEthFamExDlg::OnBnClickedBtnCancel)
	ON_CBN_SELCHANGE(IDC_COMBO_MAXSAMPLE, &CEthFamExDlg::OnCbnSelchangeComboMaxsample)
	ON_BN_CLICKED(IDC_BTN_DELETE_SINGLE, &CEthFamExDlg::OnBnClickedBtnDeleteSingle)
	ON_BN_CLICKED(IDC_BTN_DELETE_ALL, &CEthFamExDlg::OnBnClickedBtnDeleteAll)
	ON_BN_CLICKED(IDC_BTN_NETWORK, &CEthFamExDlg::OnBnClickedBtnNetwork)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_CHANGE_USER_TYPE, &CEthFamExDlg::OnBnClickedBtnChangeUserType)
	ON_BN_CLICKED(IDC_BTN_GET_USER, &CEthFamExDlg::OnBnClickedBtnGetUser)
	ON_BN_CLICKED(IDC_BTN_SEND_USER, &CEthFamExDlg::OnBnClickedBtnSendUser)
	ON_BN_CLICKED(IDC_BTN_SL, &CEthFamExDlg::OnBnClickedBtnSl)
	ON_BN_CLICKED(IDC_PERIPHERAL, &CEthFamExDlg::OnBnClickedPeripheral)
	ON_CBN_SELCHANGE(IDC_COMBO_INTERFACE, &CEthFamExDlg::OnCbnSelchangeComboInterface)
	ON_CBN_SELCHANGE(IDC_COMBO_COMPORTS, &CEthFamExDlg::OnCbnSelchangeComboComports)
	ON_CBN_SELCHANGE(IDC_COMBO_BAUDRATE, &CEthFamExDlg::OnCbnSelchangeComboBaudrate)
	ON_BN_CLICKED(IDC_BTN_HELP, &CEthFamExDlg::OnBnClickedBtnHelp)
	ON_BN_CLICKED(IDC_CHECK_SHOWIMAGE, &CEthFamExDlg::OnBnClickedCheckShowimage)
	ON_NOTIFY(IPN_FIELDCHANGED, IDC_IPADDRESS1, &CEthFamExDlg::OnIpnFieldchangedIpaddress1)
	ON_EN_CHANGE(IDC_EDIT_PORT, &CEthFamExDlg::OnEnChangeEditPort)
	ON_BN_CLICKED(IDC_CHECK_PIV, &CEthFamExDlg::OnBnClickedCheckPiv)
	ON_BN_CLICKED(IDC_CHECK_WSQ, &CEthFamExDlg::OnBnClickedCheckWsq)
END_MESSAGE_MAP()


// CEthFamExDlg message handlers

BOOL CEthFamExDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	WINDOWPLACEMENT wp;
	m_ctrlImage.GetWindowPlacement( &wp );
	// Adjust width and height to required
	wp.rcNormalPosition.right=wp.rcNormalPosition.left+320;
	wp.rcNormalPosition.bottom=wp.rcNormalPosition.top+480;
	// Set window placement
	m_ctrlImage.SetWindowPlacement( &wp );
	//
	CheckDlgButton(IDC_RADIO_SCREEN, BST_CHECKED);
	m_ctrlIP.SetAddress(192, 168, 0, 30);
	m_ctrlPort.SetWindowTextW(_T("5001"));

	m_ctrlMaxSample.AddString(_T("1"));
	m_ctrlMaxSample.AddString(_T("2"));
	m_ctrlMaxSample.AddString(_T("3"));
	m_ctrlMaxSample.AddString(_T("4"));
	m_ctrlMaxSample.AddString(_T("5"));
	m_ctrlMaxSample.AddString(_T("6"));
	m_ctrlMaxSample.AddString(_T("7"));
	m_ctrlMaxSample.AddString(_T("8"));
	m_ctrlMaxSample.AddString(_T("9"));
	m_ctrlMaxSample.AddString(_T("10"));
	m_ctrlMaxSample.SetCurSel(2);
	UpdateData(1);
	// 
	m_chkImage.SetCheck( BST_CHECKED );
	m_bShowImage = TRUE;
	//
	m_bRunning = false;
	m_nMaxSample = 3;
	m_ctrlProgress.SetRange(0, 3);
	m_ctrlProgress.SetStep(1);
	//
	m_pImage = (PBYTE) malloc( 153602 );	//320*480 + 2
	ZeroMemory(m_pImage, 153602);

	if (!m_imgShow.PrepareView(320, 480, 8))
	{
		MessageBox(_T("PrepareView Failed."), 0, MB_OK|MB_ICONSTOP);
		return FALSE;
	}

	m_cboInterface.AddString(_T("TCP/IP"));
	m_cboInterface.AddString(_T("COM Port"));
	m_cboInterface.SetCurSel(m_nInterface);
	// max buadrate
	m_cboMaxBaudrate.AddString(_T("115200"));
	m_cboMaxBaudrate.AddString(_T("230400"));
	m_cboMaxBaudrate.AddString(_T("460800"));
	m_cboMaxBaudrate.AddString(_T("921600"));
	m_cboMaxBaudrate.SetCurSel(0);
	UpdateData(1);
	m_dwBaudrate = 115200;
	m_dwMaxBaudrate = 115200;

	//enumerate com ports
	//EnumerateComPorts();
	if( CFamSerialComm::EnumerateComPorts() )
	{
		for( BYTE nCyc=0; nCyc<CFamSerialComm::m_nNumComPort; nCyc++ )
			m_cboComPorts.AddString( CFamSerialComm::m_arrEnumComPort[nCyc] );
	}

	int nCnt = m_cboComPorts.GetCount();
	if( nCnt > 0 )
	{
		CString strPorts;
		int nIndex;
		int nSelectedIndex = 0;
		for( int i=0; i<nCnt; i++ )
		{
			m_cboComPorts.GetLBText( i, strPorts );
			nIndex = strPorts.Find(' ', 0);
			strPorts = strPorts.Mid(0, nIndex);
			if( strPorts.Compare( m_pszSelectedComPort ) == 0 )
			{
				nSelectedIndex = i;
				break;
			}
		}
		m_cboComPorts.SetCurSel(nSelectedIndex);
		m_cboComPorts.GetLBText(nSelectedIndex, m_strSelectedComPort);
		nIndex = m_strSelectedComPort.Find(' ', 0);
		m_strSelectedComPort = m_strSelectedComPort.Mid(0, nIndex);
	}	

	commFam.SetInterface( m_nInterface );
	commFam.SetSocketIP( m_dwIP );
	commFam.SetSocketPort( m_nPort );
	commFam.SetComDefaultBaudrate( m_dwBaudrate );
	commFam.SetComMaxBaudrate( m_dwMaxBaudrate );
	commFam.SetMessageWindowHandle( m_ctrlMessage.m_hWnd );
	commFam.SetCommandWindowHandle( m_txtCommandList.m_hWnd );
	commFam.SetComPort( (TCHAR *)(LPCTSTR)m_strSelectedComPort );

	if( m_nInterface == 1 )
	{
		m_cboComPorts.ShowWindow(SW_SHOW);
		m_lblComPort.ShowWindow(SW_SHOW);
		m_cboMaxBaudrate.ShowWindow(SW_SHOW);
		m_lblMaxBaudrate.ShowWindow(SW_SHOW);
		m_btnHelp.ShowWindow(SW_SHOW);
		m_lblIPAddress.ShowWindow(SW_HIDE);
		m_ctrlIP.ShowWindow(SW_HIDE);
		m_lblTcpPort.ShowWindow(SW_HIDE);
		m_ctrlPort.ShowWindow(SW_HIDE);
		m_gbTcpCom.SetWindowText(_T("COM Port"));
	}

	m_chkPIV.SetCheck(BST_CHECKED);
	m_bPIV = TRUE;
	m_bWSQ = FALSE;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CEthFamExDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CEthFamExDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		DIBShow();
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CEthFamExDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CEthFamExDlg::DIBShow()
{
	CDC *pDC = m_ctrlImage.GetDC();
	m_imgShow.DIBShow( pDC->m_hDC, m_pImage );
	ReleaseDC( pDC );
}

void CEthFamExDlg::OnBnClickedBtnCapture()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	UpdateData(1);
	EnableControl(false);
	if( IsDlgButtonChecked( IDC_RADIO_SCREEN ) == BST_CHECKED )
		m_bCapture2Screen = true;
	else
		m_bCapture2Screen = false;

	// start the worker thread
	CWinThread *pThread = AfxBeginThread(CaptureThreadFunc, 
										(LPVOID)this,
										THREAD_PRIORITY_NORMAL,
										0,
										0);

	//////////////////////////////////////////////////////
	// did we create OK?
	if (pThread == NULL)
	{
		PrintMessage(_T("Failed to create Capture Thread!"));
		EnableControl(true);
		return;
	}
}

void CEthFamExDlg::OnBnClickedBtnEnroll()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();
	UpdateData(1);
	EnableControl(false);

	CDlgEnroll dlgE;
	INT_PTR nRet = dlgE.DoModal();
	if( nRet == IDOK )
	{
		m_nIDL = (UINT) dlgE.m_nUID;
		m_nIDH = (UINT) ( dlgE.m_nUID / 0x100000000 );
		m_nIDH += dlgE.m_nGroupID << 24;
		m_nIDH += dlgE.m_nFingerID << 16;
		m_nUType = dlgE.m_nUType;
		// start the worker thread
		CWinThread *pThread = AfxBeginThread(EnrollThreadFunc, 
											(LPVOID)this,
											THREAD_PRIORITY_NORMAL,
											0,
											0);

		//////////////////////////////////////////////////////
		// did we create OK?
		if (pThread == NULL)
		{
			PrintMessage(_T("Failed to create Enroll Thread!"));
			EnableControl(true);
			return;
		}
	}
	else
	{
		PrintMessage(_T("Cancel by user!"));
		EnableControl(true);
	}
}

void CEthFamExDlg::PrintErrorMessage( )
{
	CString strErrMsg;
	strErrMsg = commFam.GetErrorMessage();
	m_ctrlMessage.SetWindowText( strErrMsg );
}

void CEthFamExDlg::OnBnClickedBtnVerify()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	bCancel = false;
	UpdateData(1);
	EnableControl(false);

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}
	// get the user id first
	if( !GetUserID( FALSE ) )
	{
		EnableControl(true);
		commFam.CloseConnection();
		return;
	}
	// start the worker thread
	CWinThread *pThread = AfxBeginThread(VerifyThreadFunc, 
										(LPVOID)this,
										THREAD_PRIORITY_NORMAL,
										0,
										0);

	//////////////////////////////////////////////////////
	// did we create OK?
	if (pThread == NULL)
	{
		PrintMessage(_T("Failed to create Verify Thread!"));
		EnableControl(true);
		commFam.CloseConnection();
		return;
	}
}

void CEthFamExDlg::OnBnClickedBtnIdentify()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	UpdateData(1);
	EnableControl(false);
	// start the worker thread
	CWinThread *pThread = AfxBeginThread(IdentifyThreadFunc, 
										(LPVOID)this,
										THREAD_PRIORITY_NORMAL,
										0,
										0);

	//////////////////////////////////////////////////////
	// did we create OK?
	if (pThread == NULL)
	{
		PrintMessage(_T("Failed to create Identify Thread!"));
		EnableControl(true);
		return;
	}
}

void CEthFamExDlg::OnBnClickedBtnFw()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	UpdateData(1);
	EnableControl(false);
	PrintMessage(_T(""));

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}
	TCHAR szVerFw[16] = _T("");
	TCHAR szVerHw[16] = _T("");
	m_nErrorCode = commFam.FamGetVersion(szVerFw, szVerHw);
	if( m_nErrorCode == 0 )
	{
		CString strVersion;
		BYTE nRet;
		strVersion.Format(_T("Current Firmware Version: %s, Hardware Version: %s\n\nAre you sure to upgrade the FW?\n\n"), szVerFw, szVerHw);
		nRet = MessageBox( strVersion, 0, MB_YESNO|MB_ICONQUESTION );
		if( nRet == IDYES )
		{
			CFileDialog fileDlg
				( TRUE, 
				  NULL,
				  NULL,
				  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_EXPLORER,
				  NULL,
				  this);

			fileDlg.m_ofn.lpstrFilter = _T("BF Firmware File(*.ldr)\0*.ldr\0\0");
			fileDlg.m_ofn.lpstrDefExt = _T("*.ldr");
			fileDlg.DoModal();
			CString strPath = fileDlg.GetPathName();

			if( !strPath.IsEmpty() )
			{
				int nRet = MessageBox(_T("Please do NOT unplug the network cable or POWER OFF the Fin'Lock device!\r\n\r\n\r\n"), 0, MB_OKCANCEL | MB_ICONWARNING );
				if( nRet == IDOK )
					UpgradeIt( strPath );
			}
			else
				PrintMessage(_T("Cancel by user!"));
		}		
		else
			PrintMessage(_T("Cancel by user!"));
	}
	else
	{
		PrintErrorMessage();
	}
	EnableControl(true);
	commFam.CloseConnection();
}

bool CEthFamExDlg::DownloadFirmwareData(bool bRamFlash, int nLength, PBYTE RxBuf)
{
    if (nLength <= 0)
        return false;

    UINT nRxLength = 0;
    UINT nAddress = 0;
    UINT nTotal = (UINT)nLength;
    int nRetries = 0;
    CString strPerMsg;
    BYTE nRet = 0;

    while (nTotal > 0)
    {
        nRxLength = 1024;
        if (nRxLength > nTotal)
            nRxLength = nTotal;
        if (bRamFlash)
            nRet = commFam.FamDownloadFromRam(nAddress, nRxLength, RxBuf+nAddress);
        else
            nRet = commFam.FamDownloadFromFlash(nAddress, nRxLength, RxBuf+nAddress);
        if( nRet != 0)
        {
            nRetries++;
            if (nRetries > 2)
            {
                PrintErrorMessage();
                return false;
            }
            Sleep(20);
            continue;
        }
        nRetries = 0;
        nTotal -= nRxLength;
        nAddress += nRxLength;
        if( bRamFlash )
            strPerMsg.Format(_T("Downloading from RAM......%d%%"), (nAddress * 100) / nLength);
        else
            strPerMsg.Format(_T("Downloading from Flash......%d%%"), (nAddress * 100) / nLength);
        PrintMessage(strPerMsg);
    }
    return true;
}

bool CEthFamExDlg::UpgradeIt( CString csPath )
{
	int	i, err;
	int ncnt;
	struct	_stat	statbuf;

	err = _wstat( csPath, &statbuf );
	if ( err )
	{
		PrintMessage(_T("stat() return error"));
		return false;
	}
	m_strMessage.Format( _T("Size of file in bytes: %ld\r\n"), statbuf.st_size );
	ncnt = statbuf.st_size;
	if ( (ncnt<=0) || (ncnt>0x100000) ) 
	{
	  m_strMessage.Format(_T("ERROR: boot_file length == %ld\n"), ncnt );
	  UpdateData(0);
	  return false;
	}
	BYTE *TxBuf, *RxBuf;
	TxBuf = (BYTE *)malloc( ncnt + 12 );
	RxBuf = (BYTE *)malloc( ncnt + 12 );
	ZeroMemory( RxBuf, ncnt+12 );
	//try to download from RAM
	m_nErrorCode = commFam.FamDownloadFromRam( 0, 10, RxBuf);
	if ( m_nErrorCode == 0 )  
	{
		PrintMessage(_T("Uploading to RAM ......"));
		Sleep(200);
		FILE *fptr = NULL;
		_wfopen_s( &fptr, csPath, _T("rb") );
		if( fptr == NULL )
		{
			m_strMessage = _T("Failed to open the file!");
			UpdateData(0);
			free(TxBuf);
			free(RxBuf);
			return false;
		}
		fread( TxBuf, 1, ncnt, fptr );
		fclose(fptr);
		m_nErrorCode = commFam.FamUploadToRam( 0, ncnt, TxBuf );
		if( m_nErrorCode == 0 )
		{
			ZeroMemory( RxBuf, ncnt+12 );
			if( !DownloadFirmwareData(true, ncnt, RxBuf) )
			{
				free(TxBuf);
				free(RxBuf);
				return false;
			}
			for ( i=0; i<ncnt; i++ ) 
			{
				if( RxBuf[i] != TxBuf[i] )
				{
					m_strMessage.Format(_T("%d!=%d;error upload/download"),RxBuf[i], TxBuf[i]);
					UpdateData(0);
					free(TxBuf);
					free(RxBuf);
					return false;
				}
			}
		}
		else
		{
			PrintErrorMessage();
			free(TxBuf);
			free(RxBuf);
			return false;
		}
		m_strMessage.Format(_T("Write to RAM %d bytes."), ncnt);
		UpdateData(0);
		Sleep(200);
		m_strMessage = _T("Writing to Flash......");
		UpdateData(0);
		//---- write to flash ---------------------------------
		m_nErrorCode = commFam.FamWriteToFlash( ncnt);
		if( m_nErrorCode != 0 )
		{
			m_strMessage.Format( _T("FamWriteToFlash return error = %d\r\n"),m_nErrorCode);
			UpdateData(0);
			free(TxBuf);
			free(RxBuf);
			return false;
		}
		m_strMessage.Format(_T("Write to Flash %d bytes."), ncnt);
		//m_strStatistics += m_strMsg;
		UpdateData(0);
		Sleep(200);
		//-----	Verify---------------------------------------------
		m_strMessage =  _T("Verifing......");
		//m_strStatistics += m_strMsg;
		UpdateData(0);
		Sleep(200);
		ZeroMemory( RxBuf, ncnt+12 );
		if( !DownloadFirmwareData(false, ncnt, RxBuf) )
		{
			free(TxBuf);
			free(RxBuf);
			return false;
		}
		// Compare
		for ( i=0; i<ncnt; i++ ) 
		{
			if ( RxBuf[i] != TxBuf[i] ) 
			{
				m_strMessage.Format( _T("Compare error: addr=0x%lX, mustbe=0x%2.2X, really=0x%2.2X"),
									i, TxBuf[i], RxBuf[i] );
				UpdateData(0);
				free(TxBuf);
				free(RxBuf);
				return false;
			}
		}
		//m_strStatistics = m_strStatistics + m_strMsg + " OK!\r\n";
		commFam.FamReboot();
		m_strMessage = _T("Upgrade FAM Firmware successfully!");
		UpdateData(0);
	}
	else// In this use old algoritm
	{
		m_strMessage = _T("Old algorithm not supported!");
		UpdateData(0);
		free(TxBuf);
		free(RxBuf);
		return false;
	}
	free(TxBuf);
	free(RxBuf);
	return true;
}

void CEthFamExDlg::OnBnClickedBtnCancel()
{
	bCancel = true;
}

void CEthFamExDlg::PrintMessage( CString strMsg )
{
	m_ctrlMessage.SetWindowTextW( strMsg );
}

void CEthFamExDlg::EnableControl(bool bEnable)
{
	if( bEnable )
	{
		m_ctrlIP.EnableWindow(1);
		m_ctrlPort.EnableWindow(1);
		m_btnCapture.EnableWindow(1);
		m_btnEnroll.EnableWindow(1);
		m_btnVerify.EnableWindow(1);
		m_btnIdentify.EnableWindow(1);
		m_btnNetwork.EnableWindow(1);
		m_btnFW.EnableWindow(1);
		m_btnDelete1.EnableWindow(1);
		m_btnDeleteAll.EnableWindow(1);
		m_btnExit.EnableWindow(1);
		m_btnSL.EnableWindow(1);
		m_btnChangeUser.EnableWindow(1);
		m_btnGetUser.EnableWindow(1);
		m_btnSendUser.EnableWindow(1);
		m_btnPeripheral.EnableWindow(1);
		m_cboInterface.EnableWindow(1);
		m_cboComPorts.EnableWindow(1);
		m_cboMaxBaudrate.EnableWindow(1);
		m_btnHelp.EnableWindow(1);
		m_chkPIV.EnableWindow(1);
		m_chkWsq.EnableWindow(1);
		m_btnCancel.EnableWindow(0);
		m_bRunning = false;
	}
	else
	{
		m_ctrlIP.EnableWindow(0);
		m_ctrlPort.EnableWindow(0);
		m_btnCapture.EnableWindow(0);
		m_btnEnroll.EnableWindow(0);
		m_btnVerify.EnableWindow(0);
		m_btnIdentify.EnableWindow(0);
		m_btnNetwork.EnableWindow(0);
		m_btnFW.EnableWindow(0);
		m_btnDelete1.EnableWindow(0);
		m_btnDeleteAll.EnableWindow(0);
		m_btnExit.EnableWindow(0);
		m_btnSL.EnableWindow(0);
		m_btnChangeUser.EnableWindow(0);
		m_btnGetUser.EnableWindow(0);
		m_btnSendUser.EnableWindow(0);
		m_btnPeripheral.EnableWindow(0);
		m_cboInterface.EnableWindow(0);
		m_cboComPorts.EnableWindow(0);
		m_cboMaxBaudrate.EnableWindow(0);
		m_btnHelp.EnableWindow(0);
		m_chkPIV.EnableWindow(0);
		m_chkWsq.EnableWindow(0);
		m_btnCancel.EnableWindow(1);
	}
}

void CEthFamExDlg::OnCbnSelchangeComboMaxsample()
{
	int nIndex = m_ctrlMaxSample.GetCurSel();
	CString strMax;
	m_ctrlMaxSample.GetLBText(nIndex, strMax);
	m_nMaxSample = _wtoi(strMax);
	m_ctrlProgress.SetRange(0, m_nMaxSample);
}

void CEthFamExDlg::OnBnClickedBtnDeleteSingle()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	bCancel = false;
	UpdateData(1);
	EnableControl(false);

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}
	// get the user id first
	if( !GetUserID( FALSE ) )
	{
		EnableControl(true);
		commFam.CloseConnection();
		return;
	}
	m_nErrorCode = commFam.FamDeleteOneUser( m_nIDL, m_nIDH );
	if( m_nErrorCode == 0 )
	{
		PrintMessage(_T("User is deleted."));
	}
	else
		PrintErrorMessage();

	EnableControl(true);
	commFam.CloseConnection();
}

void CEthFamExDlg::OnBnClickedBtnDeleteAll()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	bCancel = false;
	UpdateData(1);
	EnableControl(false);

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}
	int nDlg = MessageBox(_T("Are you sure to delete all the users?\n"), _T("Delete ALL"), MB_YESNO|MB_ICONQUESTION );
	if( nDlg == IDYES )
	{
		m_nErrorCode = commFam.FamDeleteAllUser();
		if( m_nErrorCode == 0 )
			PrintMessage(_T("All the users are deleted."));
		else
			PrintErrorMessage();
	}
	else
		PrintMessage(_T("Cancel by user!"));

	EnableControl(true);
	commFam.CloseConnection();
}

void CEthFamExDlg::OnBnClickedBtnNetwork()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	bCancel = false;
	UpdateData(1);
	EnableControl(false);
	PrintMessage(_T(""));

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}

	UINT nIP2Set;
	UINT nSM2Set;
	UINT nGW2Set;
	BYTE arrMac[6];
	UINT nPort2Set;

	//Check Network setting
	m_nErrorCode = commFam.FamCheckNetwork( &nIP2Set, &nGW2Set, &nSM2Set, &nPort2Set, arrMac );
	if( m_nErrorCode != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		commFam.CloseConnection();
		return;
	}
	CDlgNetwork dlgN;
	dlgN.m_dwIP = nIP2Set;
	dlgN.m_dwGW = nGW2Set;
	dlgN.m_strM1.Format(_T("%02x"), arrMac[0]);
	dlgN.m_strM2.Format(_T("%02x"), arrMac[1]);
	dlgN.m_strM3.Format(_T("%02x"), arrMac[2]);
	dlgN.m_strM4.Format(_T("%02x"), arrMac[3]);
	dlgN.m_strM5.Format(_T("%02x"), arrMac[4]);
	dlgN.m_strM6.Format(_T("%02x"), arrMac[5]);
	dlgN.m_nPort = nPort2Set;
	dlgN.m_dwSM = nSM2Set;

	INT_PTR nDlg = dlgN.DoModal();
	if( nDlg == IDOK )
	{
		bool bChange = false;
		if( nIP2Set != dlgN.m_dwIP )
			bChange = true;
		else if( nGW2Set != dlgN.m_dwGW )
			bChange = true;
		else if( nSM2Set != dlgN.m_dwSM )
			bChange = true;
		else if( nPort2Set != dlgN.m_nPort )
			bChange = true;
		if( bChange )
		{
			nIP2Set = dlgN.m_dwIP;
			nGW2Set = dlgN.m_dwGW;
			nSM2Set = dlgN.m_dwSM;
			nPort2Set = dlgN.m_nPort;
			m_nErrorCode = commFam.FamSetNetwork( nIP2Set, nGW2Set,nSM2Set, nPort2Set, arrMac );
			if( m_nErrorCode != 0 )
			{
				PrintErrorMessage();
				EnableControl(true);
				commFam.CloseConnection();
				return;
			}
			int nMsg = MessageBox(_T("Would you like to save the change and reboot?\n\n"), 0, MB_YESNO | MB_ICONQUESTION );
			if( nMsg == IDYES )
			{
				m_nErrorCode = commFam.FamSaveNetworkSetting( );
				if( m_nErrorCode != 0 )
				{
					PrintErrorMessage();
					EnableControl(true);
					commFam.CloseConnection();
					return;
				}
				PrintMessage(_T("Reboot......"));
				commFam.FamReboot();
				PrintMessage(_T("Network setting is changed successfully!"));
			}
			else
			{
				PrintMessage(_T("Network setting is NOT saved!"));
			}
		}
		else
			PrintMessage(_T("Network setting is not changed!"));
	}
	else
	{
		PrintMessage(_T("Cancel by user!"));
	}
	EnableControl(true);
	commFam.CloseConnection();
}

void CEthFamExDlg::OnDestroy()
{
	CDialog::OnDestroy();
	// when the program is running in a Thread, and suddently shut down
	if( m_bRunning )
	{
		bCancel = true;
		Sleep(500);
	}
}

void CEthFamExDlg::OnBnClickedBtnChangeUserType()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	bCancel = false;
	UpdateData(1);
	EnableControl(false);

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}
	// get the user id first
	if( !GetUserID( TRUE ) )
	{
		EnableControl(true);
		commFam.CloseConnection();
		return;
	}
	m_nErrorCode = commFam.FamChangeUserType( m_nIDL, m_nIDH, m_nUType );
	if( m_nErrorCode == 0 )
		PrintMessage(_T("User type is changed!"));
	else
		PrintErrorMessage();

	EnableControl(true);
	commFam.CloseConnection();
}

void CEthFamExDlg::OnBnClickedBtnGetUser()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	UpdateData(1);
	EnableControl(false);

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}
	// get the user id first
	if( !GetUserID( FALSE ) )
	{
		EnableControl(true);
		commFam.CloseConnection();
		return;
	}

	PrintMessage(_T("Downloading template..."));
	PBYTE pTemplate;
	UINT nTemplateLength;
	m_nErrorCode = commFam.FamDownloadTemplateLength(m_nIDL, m_nIDH, &nTemplateLength);
	if( m_nErrorCode == 0 )
	{
		pTemplate = (PBYTE) malloc( nTemplateLength );
		if( !commFam.FamDownloadTemplate( pTemplate ) )
		{
			PrintMessage(_T("Failed to download template!"));
			EnableControl(true);
			commFam.CloseConnection();
			free( pTemplate );
			return;
		}
		CFileDialog fileDlg
			( FALSE, 
			  NULL,
			  NULL,
			  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_EXPLORER,
			  NULL,
			  this);

		fileDlg.m_ofn.lpstrFilter = _T("FAM template(*.fbn)\0*.fbn\0\0");
		fileDlg.m_ofn.lpstrDefExt = _T("*.fbn");
		fileDlg.DoModal();
		CString strPath = fileDlg.GetPathName();
		if( !strPath.IsEmpty() )
		{
			FILE *fptr = NULL;
			_wfopen_s( &fptr, strPath, _T("wb") );
			if( fptr == NULL )
			{
				PrintMessage(_T("Failed to open the file!"));
				if( pTemplate )
					free( pTemplate );
				EnableControl(true);
				commFam.CloseConnection();
				return;
			}
			fwrite( &nTemplateLength, 4, 1, fptr );
			fwrite( pTemplate, 1, nTemplateLength, fptr );
			fclose(fptr);
			PrintMessage(_T("User template is saved!"));
		}
		else
			PrintMessage(_T("Cancel by user!"));
		//
		free( pTemplate );
	}
	else
		PrintErrorMessage();

	EnableControl(true);
	commFam.CloseConnection();
}

void CEthFamExDlg::OnBnClickedBtnSendUser()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	UpdateData(1);
	EnableControl(false);

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}

	CFileDialog fileDlg
		( TRUE, 
		  NULL,
		  NULL,
		  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_EXPLORER,
		  NULL,
		  this);

	fileDlg.m_ofn.lpstrFilter = _T("FAM template(*.fbn)\0*.fbn\0\0");
	fileDlg.m_ofn.lpstrDefExt = _T("*.fbn");
	fileDlg.DoModal();
	CString strPath = fileDlg.GetPathName();
	if( !strPath.IsEmpty() )
	{
		FILE *fptr = NULL;
		_wfopen_s( &fptr, strPath, _T("rb") );
		if( fptr == NULL )
		{
			PrintMessage(_T("Failed to open the file!"));
			EnableControl(true);
			commFam.CloseConnection();
			return;
		}
		UINT nTemplateLength;
		BYTE *pTemplate;
		fread( &nTemplateLength, 4, 1, fptr );
		if( nTemplateLength > 0 )
		{
			pTemplate = (PBYTE) malloc( nTemplateLength + 2 );
			fread( pTemplate, 1, nTemplateLength, fptr );
			m_nErrorCode = commFam.FamUploadTemplate( nTemplateLength, pTemplate );
			if( m_nErrorCode == 0 )
			{
				m_nErrorCode = commFam.FamStoreTemplate(0, 0, 0x80);
				if( m_nErrorCode == 0 )
					PrintMessage(_T("User template is sent to FAM!"));
				else
					PrintErrorMessage();
			}
			else
				PrintErrorMessage();
			free( pTemplate );
		}
		else
			PrintMessage(_T("Invalid template file!"));
		fclose(fptr);
	}
	else
		PrintMessage(_T("Cancel by user!"));

	EnableControl(true);
	commFam.CloseConnection();
}

void CEthFamExDlg::OnBnClickedBtnSl()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	UpdateData(1);
	EnableControl(false);
	PrintMessage(_T(""));

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}
	UINT nPages;

	m_nErrorCode = commFam.FamGetSpace( &nPages );
	if( m_nErrorCode != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		commFam.CloseConnection();
		return;
	}
	// get global security level
	m_nErrorCode = commFam.FamGetSecurityLevel( &m_nGSL );
	if( m_nErrorCode != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		commFam.CloseConnection();
		return;
	}

	CDlgOthers dlgO;
	dlgO.m_nPages = nPages;
	dlgO.m_nGSL = m_nGSL;

	INT_PTR nDlg = dlgO.DoModal();
	if( nDlg == IDOK )
	{
		if( m_nGSL != dlgO.m_nGSL )
		{
			m_nGSL = dlgO.m_nGSL;
			m_nErrorCode = commFam.FamSetSecurityLevel( m_nGSL );
			if( m_nErrorCode == 0 )
				PrintMessage(_T("Global security level is changed!"));
			else
				PrintErrorMessage( );
		}
		else
			PrintMessage(_T("Global security level is not changed!"));
	}
	else
		PrintMessage(_T("Cancel by user!"));
	EnableControl(true);
	commFam.CloseConnection();
}

void CEthFamExDlg::WriteBMPFile()
{
	CFileDialog fileDlg
		( FALSE, 
		  NULL,
		  NULL,
		  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_EXPLORER,
		  NULL,
		  this);

	fileDlg.m_ofn.lpstrFilter = _T("Bitmap File(*.bmp)\0*.bmp\0\0");
	fileDlg.m_ofn.lpstrDefExt = _T("*.bmp");
	fileDlg.DoModal();
	CString strPath = fileDlg.GetPathName();
	if( !strPath.IsEmpty() )
	{
		m_imgShow.WriteBMPFile( (LPTSTR)(LPCTSTR)strPath, m_pImage );
		PrintMessage(_T("Bitmap is saved!"));
	}
	else
		PrintMessage(_T("Bitmap is not saved!"));
}

void CEthFamExDlg::OnBnClickedPeripheral()
{
	m_txtCommandList.SetWindowText(_T(""));
	commFam.ResetCountOfCommandList();

	bCancel = false;
	UpdateData(1);
	EnableControl(false);
	PrintMessage(_T(""));

	if( commFam.PrepareConnection() != 0 )
	{
		PrintErrorMessage();
		EnableControl(true);
		return;
	}

	CDlgPeripheral dlgP;
	dlgP.DoModal();

	EnableControl(true);
	commFam.CloseConnection();
	commFam.SetMessageWindowHandle( m_ctrlMessage.m_hWnd );
	commFam.SetCommandWindowHandle( m_txtCommandList.m_hWnd );
}

void CEthFamExDlg::OnCbnSelchangeComboInterface()
{
	m_nInterface = m_cboInterface.GetCurSel();
	if( m_nInterface == 0 )	//TCP/IP interface
	{
		m_cboComPorts.ShowWindow(SW_HIDE);
		m_lblComPort.ShowWindow(SW_HIDE);
		m_cboMaxBaudrate.ShowWindow(SW_HIDE);
		m_lblMaxBaudrate.ShowWindow(SW_HIDE);
		m_btnHelp.ShowWindow(SW_HIDE);
		m_lblIPAddress.ShowWindow(SW_SHOW);
		m_ctrlIP.ShowWindow(SW_SHOW);
		m_lblTcpPort.ShowWindow(SW_SHOW);
		m_ctrlPort.ShowWindow(SW_SHOW);
		m_gbTcpCom.SetWindowText(_T("IP && Port"));
		UpdateData(1);
		commFam.SetSocketIP( m_dwIP );
		commFam.SetSocketPort( m_nPort );
	}
	else					//COM interface
	{
		m_cboComPorts.ShowWindow(SW_SHOW);
		m_lblComPort.ShowWindow(SW_SHOW);
		m_cboMaxBaudrate.ShowWindow(SW_SHOW);
		m_lblMaxBaudrate.ShowWindow(SW_SHOW);
		m_btnHelp.ShowWindow(SW_SHOW);
		m_lblIPAddress.ShowWindow(SW_HIDE);
		m_ctrlIP.ShowWindow(SW_HIDE);
		m_lblTcpPort.ShowWindow(SW_HIDE);
		m_ctrlPort.ShowWindow(SW_HIDE);
		m_gbTcpCom.SetWindowText(_T("COM Port"));
	}
	commFam.SetInterface( m_nInterface );
}

void CEthFamExDlg::OnCbnSelchangeComboComports()
{
	int nIndex;
	nIndex = m_cboComPorts.GetCurSel();
	m_cboComPorts.GetLBText( nIndex, m_strSelectedComPort );
	nIndex = m_strSelectedComPort.Find(' ', 0);
	m_strSelectedComPort = m_strSelectedComPort.Mid(0, nIndex);
	commFam.SetComPort( (TCHAR *)(LPCTSTR)m_strSelectedComPort );
}

void CEthFamExDlg::OnCbnSelchangeComboBaudrate()
{
	int nIndex;
	nIndex = m_cboMaxBaudrate.GetCurSel();
	switch (nIndex)
	{
		case 0: 
			m_dwMaxBaudrate = 115200;
			break;
		case 1:
			m_dwMaxBaudrate = 230400;
			break;
		case 2:
			m_dwMaxBaudrate = 460800;
			break;
		case 3:
			m_dwMaxBaudrate = 921600;
			break;
	}
	commFam.SetComMaxBaudrate( m_dwMaxBaudrate );
}

void CEthFamExDlg::OnBnClickedBtnHelp()
{
	CString strMsg;
	strMsg = _T("FAM can support the following baudrate: \r\n 1- 115200,  2- 230400,  3- 460800,  4- 921600\r\n\r\n");
	strMsg += _T("After the FAM is power on, the default baudrate is set to 115200.\r\n");
	strMsg += _T("You can set the max baudrate in the program. And it is dependent on the PC COM Port.\r\n");
	strMsg += _T("For the built-in COM port of PC, the maximum baudrate is 115200.\r\n");
	strMsg += _T("For CP2101 USB to UART bridge controller, the maximum baudrate is 921600.\r\n");
	MessageBox( strMsg, _T("Help"), MB_OK | MB_ICONINFORMATION );
}

BOOL CEthFamExDlg::GetUserID( BOOL bWithUserType )
{
	//bWithUserType == true -> change the user type. Group ID and Finger ID are ignored, set to 0.
	//					and all of the same user id will be changed at the same time
	// Get user's list
	UINT nListLength = 0;

	m_nErrorCode = commFam.FamGetUserListLength( &nListLength );
	if( m_nErrorCode != 0 )
	{
		if( m_nErrorCode == RET_UNKNOWN_COMMAND )	// for FS83, command getuserlist is not supported
		{
			CDlgUserId dlgUserId;
			dlgUserId.m_bShowUType = bWithUserType;
			INT_PTR nDlgId = dlgUserId.DoModal();
			if( nDlgId == IDOK )
			{
				m_nGroupID = dlgUserId.m_nGroupID;
				m_nIDL = dlgUserId.m_nID_L;
				m_nIDH = dlgUserId.m_nID_H;
				m_nFingerID = dlgUserId.m_nFingerID;
				m_nUType = dlgUserId.m_nUType;
				if( !bWithUserType )
				{
					m_nIDH += m_nGroupID << 24;
					m_nIDH += m_nFingerID << 16;
				}
				return TRUE;
			}
			else
			{
				PrintMessage(_T("Cancel by user!"));
				return FALSE;
			}
		}
		else
		{
			PrintErrorMessage();
			return FALSE;
		}
	}
	else
	{
		if( nListLength == 0 )
		{
			PrintMessage(_T("Empty database in FAM!"));
			return FALSE;
		}
		BYTE *pUserList; 
		pUserList = (PBYTE) malloc( nListLength );
		if( !commFam.FamGetUserList( pUserList ) )
		{
			PrintMessage(_T("Failed to get the user's list!"));
			free( pUserList );
			return FALSE;
		}
		CDlgUserList dlgList;
		dlgList.m_nLength = nListLength;
		dlgList.m_pUList = pUserList;
		dlgList.m_bShowUType = bWithUserType;

		INT_PTR nDlg = dlgList.DoModal();
		if( nDlg == IDOK )
		{
			if( bWithUserType && dlgList.m_nUType == dlgList.m_nUTypeOld )
			{
				PrintMessage(_T("User type is not changed!"));
				if( pUserList )
					free( pUserList );
				return FALSE;
			}
			else
			{
				m_nGroupID = dlgList.m_nGroupID;
				m_nIDL = dlgList.m_nID_L;
				m_nIDH = dlgList.m_nID_H;
				m_nFingerID = dlgList.m_nFingerID;
				if( !bWithUserType )
				{
					m_nIDH += m_nGroupID << 24;
					m_nIDH += m_nFingerID << 16;
				}
				m_nUType = dlgList.m_nUType;
				if( pUserList )
					free( pUserList );
				return TRUE;
			}
		}
		else
		{
			PrintMessage(_T("Cancel by user!"));
			if( pUserList )
				free( pUserList );
			return FALSE;
		}
	}
}

void CEthFamExDlg::OnBnClickedCheckShowimage()
{
	int nChk;
	nChk = m_chkImage.GetCheck();
	if( nChk == BST_CHECKED )
		m_bShowImage = TRUE;
	else
	{
		m_bShowImage = FALSE;
		ZeroMemory(m_pImage, 153602);
		DIBShow();
	}
}


void CEthFamExDlg::OnIpnFieldchangedIpaddress1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMIPADDRESS pIPAddr = reinterpret_cast<LPNMIPADDRESS>(pNMHDR);
	// TODO: Add your control notification handler code here
	UpdateData(1);
	commFam.SetSocketIP(m_dwIP);
	*pResult = 0;
}

void CEthFamExDlg::OnEnChangeEditPort()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	UpdateData(1);
	commFam.SetSocketPort(m_nPort);
}

void CEthFamExDlg::OnBnClickedCheckPiv()
{
	if( m_chkPIV.GetCheck() == BST_CHECKED)
		m_bPIV = TRUE;
	else
		m_bPIV = FALSE;
}

void CEthFamExDlg::OnBnClickedCheckWsq()
{
	if( m_chkWsq.GetCheck() == BST_CHECKED)
		m_bWSQ = TRUE;
	else
		m_bWSQ = FALSE;
}
