// EthFamExDlg.h : header file
//

#pragma once
#include "afxwin.h"
#include "afxcmn.h"
#include "FamComm.h"
#include "FamShowImage.h"

UINT CaptureThreadFunc(LPVOID data);
UINT IdentifyThreadFunc(LPVOID data);
UINT EnrollThreadFunc(LPVOID data);
UINT VerifyThreadFunc(LPVOID data);

// CEthFamExDlg dialog
class CEthFamExDlg : public CDialog
{
// Construction
public:
	CEthFamExDlg(CWnd* pParent = NULL);	// standard constructor
	virtual ~CEthFamExDlg();

// Dialog Data
	enum { IDD = IDD_ETHFAMEX_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	CStatic m_ctrlImage;
public: 
	// Data for show fingerprint image
	PBYTE m_pImage;
	//BITMAPINFO     *lpDIBHeader;
	//char           *lbDIBData;
	//LPLOGPALETTE   lpPal;
	//HPALETTE       hPGrayscale;
	//BITMAPFILEHEADER  bmfHeader;
	bool bCancel;
	
	BYTE m_nGroupID;
	BYTE m_nFingerID;
	UINT m_nIDL, m_nIDH;
	BYTE m_nUType;
	int m_nMaxSample;
	bool m_bRunning;
	BYTE m_nGSL;
	bool m_bCapture2Screen;
	
	//BOOL PrepareView( int w, int h, int d );
	//void DIBShow();

	void PrintErrorMessage();
	void PrintMessage( CString strMsg );

	bool UpgradeIt( CString csPath );

	void EnableControl(bool bEnable);

	int m_nInterface;
	BYTE m_nErrorCode;
	DWORD m_dwBaudrate;
	DWORD m_dwMaxBaudrate;
	TCHAR m_pszInitFile[256];
	TCHAR m_pszSelectedComPort[10];
	CString m_strSelectedComPort;

	BOOL m_bShowImage;
	BOOL m_bPIV;
	BOOL m_bWSQ;

	BOOL GetUserID( BOOL bWithUserType );

	CFamShowImage m_imgShow;
	void DIBShow();
	void WriteBMPFile();

	bool DownloadFirmwareData(bool bRamFlash, int nLength, PBYTE RxBuf);

public:
	afx_msg void OnBnClickedBtnCapture();
public:
	DWORD m_dwIP;
public:
	CEdit m_ctrlPort;
public:
	UINT m_nPort;
public:
	CIPAddressCtrl m_ctrlIP;
public:
	afx_msg void OnBnClickedBtnEnroll();
public:
	CProgressCtrl m_ctrlProgress;
public:
	CString m_strMessage;
public:
	afx_msg void OnBnClickedBtnVerify();
public:
	afx_msg void OnBnClickedBtnIdentify();
public:
	afx_msg void OnBnClickedBtnFw();
public:
	afx_msg void OnBnClickedBtnCancel();
public:
	CStatic m_ctrlMessage;
public:
	CButton m_btnNetwork;
public:
	CButton m_btnFW;
public:
	CButton m_btnCapture;
public:
	CButton m_btnVerify;
public:
	CButton m_btnEnroll;
public:
	CButton m_btnIdentify;
public:
	CButton m_btnCancel;
public:
	CComboBox m_ctrlMaxSample;
public:
	CButton m_btnDelete1;
public:
	CButton m_btnDeleteAll;
public:
	afx_msg void OnCbnSelchangeComboMaxsample();
public:
	afx_msg void OnBnClickedBtnDeleteSingle();
public:
	afx_msg void OnBnClickedBtnDeleteAll();
public:
	afx_msg void OnBnClickedBtnNetwork();
public:
	CButton m_btnGetUser;
public:
	CButton m_btnSendUser;
public:
	afx_msg void OnBnClickedOk();
public:
	afx_msg void OnDestroy();
public:
	CButton m_btnExit;
public:
	CButton m_btnSL;
public:
	CButton m_btnChangeUser;
public:
	afx_msg void OnBnClickedBtnChangeUserType();
public:
	afx_msg void OnBnClickedBtnGetUser();
public:
	afx_msg void OnBnClickedBtnSendUser();
public:
	afx_msg void OnBnClickedBtnSl();
	afx_msg void OnBnClickedPeripheral();
	CButton m_btnPeripheral;
	CComboBox m_cboComPorts;
	CComboBox m_cboInterface;
	afx_msg void OnCbnSelchangeComboInterface();
	CStatic m_lblIPAddress;
	CStatic m_lblTcpPort;
	CStatic m_lblComPort;
	CStatic m_gbTcpCom;
	afx_msg void OnCbnSelchangeComboComports();
	CComboBox m_cboMaxBaudrate;
	CButton m_btnHelp;
	CStatic m_lblMaxBaudrate;
	afx_msg void OnCbnSelchangeComboBaudrate();
	afx_msg void OnBnClickedBtnHelp();
	afx_msg void OnBnClickedCheckShowimage();
	CButton m_chkImage;
	CEdit m_txtCommandList;
	afx_msg void OnIpnFieldchangedIpaddress1(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnEnChangeEditPort();
	CButton m_chkPIV;
	afx_msg void OnBnClickedCheckPiv();
	CButton m_chkWsq;
	afx_msg void OnBnClickedCheckWsq();
};

