#include "StdAfx.h"
#include "FamComm.h"

CFamComm::CFamComm(void)
{
	m_nInterface = 0;
}

CFamComm::~CFamComm(void)
{
}

void CFamComm::SetInterface(int nInterface)
{
	if( nInterface > 0 )
		m_nInterface = 1;
	else
		m_nInterface = 0;
}

void CFamComm::SetMessageWindowHandle( HWND hwndMsg )
{
	m_msgShow.SetWndMsg( hwndMsg );
}

void CFamComm::SetCommandWindowHandle( HWND hwndCmd )
{
	m_msgShow.SetWndCmd( hwndCmd );
}

void CFamComm::SetSocketIP( DWORD dwIP )
{
	m_commSocket.SetSocketIP( dwIP );
}

void CFamComm::SetSocketPort( UINT nPort )
{
	m_commSocket.SetSocketPort( nPort );
}

void CFamComm::SetComPort( TCHAR *szCom )
{
	m_commSerial.SetComPort( szCom );
}

void CFamComm::SetComDefaultBaudrate( DWORD dwBaudrate )
{
	m_commSerial.SetComDefaultBaudrate( dwBaudrate );
}

void CFamComm::SetComMaxBaudrate( DWORD dwMaxBaudrate )
{
	m_commSerial.SetComMaxBaudrate( dwMaxBaudrate );
}

BYTE CFamComm::PrepareConnection()
{
	if( m_nInterface == 0 )	// TCP/IP connection
	{
		m_nErrorCode = m_commSocket.PrepareSocket();
	}
	else					// Com port connection
	{
		m_nErrorCode = m_commSerial.PrepareComPort();
	}
	return m_nErrorCode;
}

void CFamComm::CloseConnection()
{
	if( m_nInterface == 0 )	// TCP/IP connection
		m_commSocket.CloseSocket();
	else
		m_commSerial.CloseComPort();
}

BYTE CFamComm::CommunicateWithFAC(BYTE nCommand, UINT param1, UINT param2, BYTE nFlag, BYTE *TxBuf, BYTE *RxBuf)
{
	if( m_nInterface == 0 )
		m_nErrorCode = m_commSocket.CommunicateWithFAC( nCommand, param1, param2, nFlag, m_RxCmd, TxBuf, RxBuf);
	else
		m_nErrorCode = m_commSerial.CommunicateWithFAC( nCommand, param1, param2, nFlag, m_RxCmd, TxBuf, RxBuf);
	return m_nErrorCode;
}

void CFamComm::ResetCountOfCommandList()
{
	m_msgShow.ResetCountOfCommandList();
}

BYTE CFamComm::FamIsFingerPresent()
{
	return CommunicateWithFAC( COMMAND_CHECK_FINGER, 0, 0, 0, NULL, NULL);
}

BYTE CFamComm::FamConvertRawToWsq(BYTE nBitrate, UINT &nWsqSize)
{
	m_nErrorCode =CommunicateWithFAC( COMMAND_CONVERT_RAW_TO_WSQ, nBitrate, 0, 0x01, NULL, NULL);
	if( m_nErrorCode == 0 )
	{
		memcpy( &nWsqSize, m_RxCmd+6, 4 );
	}
	return m_nErrorCode;
}

BYTE CFamComm::FamDownloadWSQImage( BYTE *pWSQImage, UINT nWsqSize )
{
	return CommunicateWithFAC(COMMAND_DOWNLOAD_WSQ_IMAGE, 0, nWsqSize, 0, NULL, pWSQImage);
}

BYTE CFamComm::FamCaptureImage(BOOL bPIV, UINT *nContrast, UINT *nBrightness)
{
	UINT nC = 0;
	UINT nB = 0;
    UINT nParam1 = 0;
    if (bPIV)
        nParam1 = 0x08;
	m_nErrorCode = CommunicateWithFAC( COMMAND_CAPTURE_IMAGE, nParam1, 0, 0, NULL, NULL);
	if( m_nErrorCode == 0 )
	{
		memcpy( &nC, m_RxCmd+2, 4 );
		memcpy( &nB, m_RxCmd+6, 4 );
	}
	*nContrast = nC;
	*nBrightness = nB;
	return m_nErrorCode;
}

BYTE CFamComm::FamDownloadRAWImage( BYTE *pImage )
{
	return CommunicateWithFAC(COMMAND_DOWNLOAD_RAW_IMAGE, 0, 320*480, 0, NULL, pImage);
}

BYTE CFamComm::FamDownloadRAWImage_Size_Offset( BYTE *pImage,UINT nImgSize ,UINT nOffset)
{
    return CommunicateWithFAC(COMMAND_DOWNLOAD_RAW_IMAGE, nOffset, nImgSize, 0, NULL, pImage);
}

BYTE CFamComm::FamProcessImage()
{
	return CommunicateWithFAC(COMMAND_PROCESS_IMAGE, 0, 0, 0, NULL, NULL);	
}

BYTE CFamComm::FamStoreSample( BYTE nSample )
{
	return CommunicateWithFAC(COMMAND_STORE_SAMPLE, nSample, 0, 0, NULL, NULL);	
}

BYTE CFamComm::FamStoreTemplate( UINT nID_L, UINT nID_H, BYTE nUType )
{
	return CommunicateWithFAC(COMMAND_STORE_TEMPLATE, nID_L, nID_H, nUType, NULL, NULL);	
}

BYTE CFamComm::FamVerify( UINT nID_L, UINT nID_H )
{
	return CommunicateWithFAC(COMMAND_MATCH_FINGER, nID_L, nID_H, FLAG_1_1_MATCH, NULL, NULL);	
}

BYTE CFamComm::FamIdentify( UINT *nID_L, UINT *nID_H )
{
	m_nErrorCode = CommunicateWithFAC(COMMAND_MATCH_FINGER, 0, 0, FLAG_1_N_MATCH, NULL, NULL);	
	if( m_nErrorCode != 0 )
		return m_nErrorCode;

	memcpy( nID_L, m_RxCmd+2, 4 );
	memcpy( nID_H, m_RxCmd+6, 4 );
	return 0;
}

BYTE CFamComm::FamGetUserListLength(UINT *nLength)
{
	m_nErrorCode = CommunicateWithFAC(COMMAND_DOWNLOAD_USER_LIST, 0, 0, 1, NULL, NULL);	
	if( m_nErrorCode == 0 )
	{
		if( m_nInterface == 0 )
			*nLength = m_commSocket.GetDataBufferLength();
		else
			*nLength = m_commSerial.GetDataBufferLength();
	}
	return m_nErrorCode;
}

BOOL CFamComm::FamGetUserList( BYTE *pUserList )
{
	if( m_nInterface == 0 )
		return m_commSocket.GetDataBuffer(pUserList);
	else
		return m_commSerial.GetDataBuffer(pUserList);
}

BYTE CFamComm::FamUploadToRam( int nAddress, int nLength, BYTE *TxBuf )
{
	return CommunicateWithFAC(COMMAND_UPLOAD_TO_RAM, nAddress, nLength, 0, TxBuf, NULL);	
}

BYTE CFamComm::FamDownloadFromRam( int nAddress, int nLength, BYTE *RxBuf )
{
	return CommunicateWithFAC(COMMAND_DOWNLOAD_FROM_RAM, nAddress, nLength, 0, NULL, RxBuf);	
}

BYTE CFamComm::FamDownloadFromFlash( int nAddress, int nLength, BYTE *RxBuf )
{
	return CommunicateWithFAC(COMMAND_DOWNLOAD_FROM_FLASH, nAddress, nLength, 0, NULL, RxBuf);	
}

BYTE CFamComm::FamWriteToFlash( int nLength )
{
	return CommunicateWithFAC(COMMAND_WRITE_TO_FLASH, nLength, 0, 0, NULL, NULL);	
}

BYTE CFamComm::FamReboot( )
{
	return CommunicateWithFAC(COMMAND_SOFTWARE_REBOOT, 0, 0, 0, NULL, NULL);	
}

BYTE CFamComm::FamCheckNetwork(UINT *nIP, UINT *nGW, UINT *nSM, UINT *nPort, BYTE *byMac)
{
	*nIP = *nGW = *nSM = 0;
	ZeroMemory( byMac, 6 );

	m_nErrorCode = CommunicateWithFAC(COMMAND_NETWORK_SETTING, 0, 0, FLAG_GET_IP_GW, NULL, NULL);	
	if( m_nErrorCode != 0 )
		return m_nErrorCode;

	memcpy( nIP, m_RxCmd+2, 4 );
	memcpy( nGW, m_RxCmd+6, 4 );

	m_nErrorCode = CommunicateWithFAC(COMMAND_NETWORK_SETTING, 0, 0, FLAG_GET_MAC_PORT, NULL, NULL);	
	if( m_nErrorCode != 0 )
		return m_nErrorCode;

	byMac[0] = m_RxCmd[7];
	byMac[1] = m_RxCmd[6];
	byMac[2] = m_RxCmd[5];
	byMac[3] = m_RxCmd[4];
	byMac[4] = m_RxCmd[3];
	byMac[5] = m_RxCmd[2];
	*nPort = m_RxCmd[8] + m_RxCmd[9] * 256;

	m_nErrorCode = CommunicateWithFAC(COMMAND_NETWORK_SETTING, 0, 0, FLAG_GET_SM, NULL, NULL);	
	if( m_nErrorCode != 0 )
		return m_nErrorCode;
	memcpy( nSM, m_RxCmd+2, 4 );
	
	return 0;
}

BYTE CFamComm::FamSetNetwork( UINT nIP, UINT nGW, UINT nSM, UINT nPort, BYTE *byMac )
{
	m_nErrorCode = CommunicateWithFAC(COMMAND_NETWORK_SETTING, nIP, nGW, FLAG_SET_IP_GW, NULL, NULL);	
	if( m_nErrorCode != 0 )
		return m_nErrorCode;

	UINT param1, param2;
	param1 = byMac[5] + (byMac[4]<<8) + (byMac[3]<<16) + (byMac[2]<<24);
	param2 = (nPort<<16) + (byMac[0]<<8) + byMac[1];

	m_nErrorCode = CommunicateWithFAC(COMMAND_NETWORK_SETTING, param1, param2, FLAG_SET_MAC_PORT, NULL, NULL);	
	if( m_nErrorCode != 0 )
		return m_nErrorCode;

	m_nErrorCode = CommunicateWithFAC(COMMAND_NETWORK_SETTING, nSM, 0, FLAG_SET_SM, NULL, NULL);	
	return m_nErrorCode;
}

BYTE CFamComm::FamSaveNetworkSetting( )
{
	return CommunicateWithFAC(COMMAND_NETWORK_SETTING, 0, 0, FLAG_SAVE_SETTING, NULL, NULL);	
}

BYTE CFamComm::FamGetVersion(TCHAR *szVerFw, TCHAR *szVerHw)
{
	m_nErrorCode = CommunicateWithFAC(COMMAND_GET_VERSION, 0, 0, 0, NULL, NULL);	
	if( m_nErrorCode == 0 )
	{
		wsprintf(szVerFw, _T("%d.%d%c"), m_RxCmd[4], m_RxCmd[2], m_RxCmd[7]);
		wsprintf(szVerHw, _T("%d.%d"), m_RxCmd[8], m_RxCmd[6]);
	}
	return m_nErrorCode;
}

BYTE CFamComm::FamDeleteOneUser(UINT nIDL, UINT nIDH)
{
	return CommunicateWithFAC(COMMAND_DELETE_1_USER, nIDL, nIDH, 1, NULL, NULL);
}

BYTE CFamComm::FamDeleteAllUser()
{
	return CommunicateWithFAC(COMMAND_DELETE_ALL_USER, 0, 0, 0, NULL, NULL);
}

BYTE CFamComm::FamChangeUserType(UINT nIDL, UINT nIDH, BYTE nUType)
{
	return CommunicateWithFAC(COMMAND_CHANGE_USER_TYPE, nIDL, nIDH, nUType, NULL, NULL);
}

BYTE CFamComm::FamDownloadTemplateLength( UINT nIDL, UINT nIDH, UINT *nTemplateLength )
{
	m_nErrorCode = CommunicateWithFAC(COMMAND_DOWNLOAD_TEMPLATE, nIDL, nIDH, 0, NULL, NULL);
	if( m_nErrorCode == 0 )
	{
		if( m_nInterface == 0 )
			*nTemplateLength = m_commSocket.GetDataBufferLength();
		else
			*nTemplateLength = m_commSerial.GetDataBufferLength();
	}
	return m_nErrorCode;
}

BYTE CFamComm::FamDownloadTemplate( BYTE *pTemplate )
{
	if( m_nInterface == 0 )
		return m_commSocket.GetDataBuffer(pTemplate);
	else
		return m_commSerial.GetDataBuffer(pTemplate);
}

BYTE CFamComm::FamUploadTemplate( UINT nTemplateLength, BYTE *pTemplate )
{
	return CommunicateWithFAC(COMMAND_UPLOAD_TEMPLATE, 0, nTemplateLength, 0, pTemplate, NULL);
}

BYTE CFamComm::FamGetSpace( UINT *nPages )
{
	m_nErrorCode = CommunicateWithFAC(COMMAND_GET_SPACE, 0, 0, 0, NULL, NULL);
	if( m_nErrorCode == 0 )
		memcpy( nPages, m_RxCmd+2, 4 );
	return m_nErrorCode;
}

BYTE CFamComm::FamGetSecurityLevel( BYTE *nSLevel )
{
	m_nErrorCode = CommunicateWithFAC(COMMAND_SECURITY_LEVEL, 0, 0, 0, NULL, NULL);
	if( m_nErrorCode == 0 )
		*nSLevel = m_RxCmd[2];
	return m_nErrorCode;
}

BYTE CFamComm::FamSetSecurityLevel( BYTE nSLevel )
{
	return CommunicateWithFAC(COMMAND_SECURITY_LEVEL, nSLevel, 0, 1, NULL, NULL);	
}

BYTE CFamComm::FamPeripherialControl( UINT param1, UINT param2, BYTE *nSensorState )
{
	m_nErrorCode = CommunicateWithFAC(COMMAND_PERIPHERIAL_CONTROL, param1, param2, 0, NULL, NULL);	
	if( m_nErrorCode == 0 )
		*nSensorState = m_RxCmd[2];
	return m_nErrorCode;
}

TCHAR * CFamComm::GetErrorMessage()
{
	if( m_nInterface == 1 )
	{
		if( m_commSerial.IsComError() )
		{
			return m_commSerial.GetComErrMsg();
		}
	}

	switch( m_nErrorCode )
	{
	case RET_NO_IMAGE:
		wcscpy_s( m_szErrMsg, 128, _T("Not Image!\0\0") );
		break;
	case RET_BAD_QUALITY:
		wcscpy_s( m_szErrMsg, 128, _T("Bad Quality!\0\0") );
		break;
	case RET_TOO_LITTLE_POINTS:
		wcscpy_s( m_szErrMsg, 128, _T("Too little points!\0\0") );
		break;
	case RET_EMPTY_BASE:
		wcscpy_s( m_szErrMsg, 128, _T("Empty database!\0\0") );
		break;
	case RET_UNKNOWN_USER:
		wcscpy_s( m_szErrMsg, 128, _T("Unknown user!\0\0") );
		break;
	case RET_NO_SPACE:
		wcscpy_s( m_szErrMsg, 128, _T("Not enough memory!\0\0") );
		break;
	case RET_BAD_ARGUMENT:
		wcscpy_s( m_szErrMsg, 128, _T("Bad argument!\0\0") );
		break;
	case RET_CRC_ERROR:
		wcscpy_s( m_szErrMsg, 128, _T("CRC error!\0\0") );
		break;
	case RET_RXD_TIMEOUT:
		wcscpy_s( m_szErrMsg, 128, _T("Rx data time out!\0\0") );
		break;
	case RET_USER_ID_IS_ABSENT:
		wcscpy_s( m_szErrMsg, 128, _T("User id does NOT existed!\0\0") );
		break;
	case RET_USER_ID_IS_USED:
		wcscpy_s( m_szErrMsg, 128, _T("User id existed!\0\0") );
		break;
	case RET_VERY_SIMILAR_SAMPLE:
		wcscpy_s( m_szErrMsg, 128, _T("Sample is very similar!\0\0") );
		break;
	case RET_USER_SUSPENDED:
		wcscpy_s( m_szErrMsg, 128, _T("User is suspended!\0\0") );
		break;
	case RET_UNKNOWN_COMMAND:
		wcscpy_s( m_szErrMsg, 128, _T("Unknown command!\0\0") );
		break;
	case RET_INVALID_STOP_BYTE:
		wcscpy_s( m_szErrMsg, 128, _T("Invalid stop byte!\0\0") );
		break;
	case RET_HARDWARE_ERROR:
		wcscpy_s( m_szErrMsg, 128, _T("Hardware error!\0\0") );
		break;
	case RET_BAD_FLASH:
		wcscpy_s( m_szErrMsg, 128, _T("Bad flash!\0\0") );
		break;
	case RET_TOO_MANY_VIP:
		wcscpy_s( m_szErrMsg, 128, _T("Too many VIP!\0\0") );
		break;
	case RET_CONNECT_TIMEOUT:
		wcscpy_s( m_szErrMsg, 128, _T("Time out to connect to FAM!\0\0") );
		break;
	case RET_WINSOCK_ERROR:
		wsprintf( m_szErrMsg, _T("Socket ERROR! Error code is: 0x%x\0\0"), WSAGetLastError() );
		break;
	default:
		wsprintf( m_szErrMsg, _T("Unknown error: 0x%x\0\0"), m_nErrorCode );
		break;
	}
	return m_szErrMsg;
}
