#pragma once

#include "FamSocketComm.h"
#include "FamSerialComm.h"
#include "FamDefs.h"
#include "FamShowMessage.h"

class CFamComm
{
public:
	CFamComm(void);
	~CFamComm(void);

	CFamSocketComm m_commSocket;
	CFamSerialComm m_commSerial;
	CFamShowMessage m_msgShow;

	void SetMessageWindowHandle( HWND hwndMsg );
	void SetCommandWindowHandle( HWND hwndCmd );

	TCHAR * GetErrorMessage();
	void SetInterface(int nInterface);
	void SetSocketIP( DWORD dwIP );
	void SetSocketPort( UINT nPort );
	void SetComPort( TCHAR *szCom );
	void SetComDefaultBaudrate( DWORD dwBaudrate );
	void SetComMaxBaudrate( DWORD dwMaxBaudrate );
	void ResetCountOfCommandList();

	//Fam Communication Commands
	BYTE PrepareConnection();
	void CloseConnection();
	BYTE FamIsFingerPresent();
	BYTE FamCaptureImage(BOOL bPIV, UINT *nContrast, UINT *nBrightness);
	BYTE FamDownloadRAWImage(BYTE *pImage);
	BYTE FamDownloadRAWImage_Size_Offset( BYTE *pImage,UINT nImgSize ,UINT nOffset);
	BYTE FamProcessImage();
	BYTE FamStoreSample( BYTE nSample );
	BYTE FamStoreTemplate( UINT nID_L, UINT nID_H, BYTE nUType );
	BYTE FamVerify( UINT nID_L, UINT nID_H );
	BYTE FamIdentify( UINT *nID_L, UINT *nID_H );
	BYTE FamGetUserListLength(UINT *nLength);
	BOOL FamGetUserList( BYTE *pUserList );
	BYTE FamUploadToRam( int nAddress, int nLength, BYTE *TxBuf );
	BYTE FamDownloadFromRam( int nAddress, int nLength, BYTE *RxBuf );
	BYTE FamDownloadFromFlash( int nAddress, int nLength, BYTE *RxBuf );
	BYTE FamWriteToFlash( int nLength );
	BYTE FamReboot();
	BYTE FamCheckNetwork(UINT *nIP, UINT *nGW, UINT *nSM, UINT *nPort, BYTE *byMac);
	BYTE FamSetNetwork( UINT nIP, UINT nGW, UINT nSM, UINT nPort, BYTE *byMac );
	BYTE FamSaveNetworkSetting();
	BYTE FamGetVersion(TCHAR *szVerFw, TCHAR *szVerHw);
	BYTE FamDeleteOneUser(UINT nIDL, UINT nIDH);
	BYTE FamDeleteAllUser();
	BYTE FamChangeUserType(UINT nIDL, UINT nIDH, BYTE nUType);
	BYTE FamDownloadTemplateLength( UINT nIDL, UINT nIDH, UINT *nTemplateLength );
	BYTE FamDownloadTemplate(BYTE *pTemplate);
	BYTE FamUploadTemplate(UINT nTemplateLength, BYTE *pTemplate );
	BYTE FamGetSpace( UINT *nPages );
	BYTE FamGetSecurityLevel( BYTE *nSLevel );
	BYTE FamSetSecurityLevel( BYTE nSLevel );
	BYTE FamPeripherialControl( UINT param1, UINT param2, BYTE *nSensorState );
	BYTE FamConvertRawToWsq( BYTE nBitrate, UINT &nWsqSize );	//v3.0.1
	BYTE FamDownloadWSQImage( BYTE *pWSQImage, UINT nWsqSize );	//v3.0.1

private:
	BYTE CommunicateWithFAC(BYTE nCommand, UINT param1, UINT param2, BYTE nFlag, BYTE *RxBuf, BYTE *TxBuf);

	int m_nInterface;
	BYTE m_RxCmd[13];
	BYTE m_nErrorCode;
	TCHAR m_szErrMsg[128];
};
