#include "StdAfx.h"
#include "FamSerialComm.h"
#include <Setupapi.h>
#include "FamShowMessage.h"

#ifndef GUID_DEVINTERFACE_COMPORT
DEFINE_GUID(GUID_DEVINTERFACE_COMPORT, 0x86E0D1E0L, 0x8089, 0x11D0, 0x9C, 0xE4, 0x08, 0x00, 0x3E, 0x30, 0x1F, 0x73);
#endif

CFamSerialComm::CFamSerialComm(void)
{
	m_bComError = FALSE;
	m_nNumComPort = 0;
	m_nRxDataLength = 0;
	m_pRxDataBuffer = NULL;
	m_dwMaxBaudrate = 115200;
	m_nFAMBaudrate = FAM_BAUDRATE_115200;
	m_hComm = NULL;
	ZeroMemory( m_szComPort, sizeof(m_szComPort) );
}

CFamSerialComm::~CFamSerialComm(void)
{
	if( m_hComm != NULL )
	{
		CloseHandle( m_hComm );
		m_hComm = NULL;
	}
	if( m_pRxDataBuffer != NULL )
	{
		free( m_pRxDataBuffer );
		m_pRxDataBuffer = NULL;
	}
}

void CFamSerialComm::SetComPort( TCHAR *szCom )
{
	size_t nSize =  sizeof(m_szComPort);
	wcscpy_s( m_szComPort, nSize, szCom );
}

void CFamSerialComm::SetComDefaultBaudrate( DWORD dwBaudrate )
{
	m_dwBaudrate = dwBaudrate;
}

void CFamSerialComm::SetComMaxBaudrate( DWORD dwMaxBaudrate )
{
	m_dwMaxBaudrate = dwMaxBaudrate;
	switch ( m_dwMaxBaudrate )
	{
		case 115200:
			m_nFAMBaudrate = FAM_BAUDRATE_115200;
			break;
		case 230400:
			m_nFAMBaudrate = FAM_BAUDRATE_230400;
			break;
		case 460800:
			m_nFAMBaudrate = FAM_BAUDRATE_460800;
			break;
		case 921600:
			m_nFAMBaudrate = FAM_BAUDRATE_921600;
			break;
	}
}

BYTE CFamSerialComm::PrepareComPort()
{
	BOOL bResult = FALSE;
	BYTE RxCmd[13];
	TCHAR szMsg[64];
	BOOL bConnected = FALSE;

	m_bComError = TRUE;
	CFamShowMessage::PrintMessage( _T("Connecting...") );

	// if the port is already opened: close it
	if (m_hComm != NULL)
	{
		CloseHandle(m_hComm);
		m_hComm = NULL;
	}
	// prepare port strings
	//sprintf(szBaud, "baud=%d parity=%c data=%d stop=%d", baud, parity, databits, stopbits);

	// get a handle to the port
	// "\\\\.\\COMX"
	TCHAR szFullComPortName[64] = _T("\\\\.\\");
	wcscat_s( szFullComPortName, 64, m_szComPort );
	m_hComm = CreateFile(szFullComPortName,						// communication port string (COMX)
					     GENERIC_READ | GENERIC_WRITE,	// read/write types
					     0,								// comm devices must be opened with exclusive access
					     NULL,							// no security attributes
					     OPEN_EXISTING,					// comm devices must use OPEN_EXISTING
					     0,	//FILE_FLAG_OVERLAPPED,		// Async I/O
					     0);							// template must be 0 for comm devices

	if (m_hComm == INVALID_HANDLE_VALUE)
	{
		wsprintf( m_szComErrMsg, _T("Failed to CreateFile(). Error: %d"), GetLastError() );
		return 1;
	}

	// set the timeout values
	m_CommTimeouts.ReadIntervalTimeout = 1000;
	m_CommTimeouts.ReadTotalTimeoutMultiplier = 100;
	m_CommTimeouts.ReadTotalTimeoutConstant = 0;
	m_CommTimeouts.WriteTotalTimeoutMultiplier = 1000;
	m_CommTimeouts.WriteTotalTimeoutConstant = 0;

	// configure
	if (SetCommTimeouts(m_hComm, &m_CommTimeouts))
	{						   
		if (GetCommState(m_hComm, &m_dcb))
		{
			// Fill in DCB: 115200 bps, 8 data bits, no parity, and 1 stop bit.
			m_dcb.BaudRate = m_dwBaudrate;     // set the baud rate
			m_dcb.ByteSize = 8;             // data size, xmit, and rcv
			m_dcb.Parity = NOPARITY;        // no parity bit
			m_dcb.StopBits = ONESTOPBIT;    // one stop bit
			m_dcb.fRtsControl  = RTS_CONTROL_DISABLE;
			m_dcb.fDtrControl  = DTR_CONTROL_DISABLE;
			if (SetCommState(m_hComm, &m_dcb))
			{
				// flush the port
				PurgeComm(m_hComm, PURGE_RXCLEAR | PURGE_TXCLEAR | PURGE_RXABORT | PURGE_TXABORT);
				wsprintf(szMsg, _T("Checking BaudRate - %d..."), m_dwBaudrate);
				CFamShowMessage::PrintMessage(szMsg);
				if( CommunicateWithFAC( COMMAND_GET_VERSION, 0, 0, 0, RxCmd, NULL, NULL) == 0 )
					bConnected = TRUE;
			}
			else
			{
				CloseHandle(m_hComm);
				m_hComm = NULL;
				wsprintf( m_szComErrMsg, _T("SetCommState() failed! Error: %d"), GetLastError() );
				return 1;
			}		
			// After the FAM is power on, the baudrate in FAM is set to 115200.
			// during the program is running and the FAM is power off /on, 
			// try the 115200 first
			if( !bConnected && m_dwBaudrate != 115200 )
			{
				m_dcb.BaudRate = 115200;
				if (SetCommState(m_hComm, &m_dcb))
				{
					CFamShowMessage::PrintMessage(_T("Checking BaudRate - 115200..."));
					if( CommunicateWithFAC( COMMAND_GET_VERSION, 0, 0, 0, RxCmd, NULL, NULL) == 0 )
					{
						m_dwBaudrate = 115200;
						bConnected = TRUE;
					}
				}
				else
				{
					CloseHandle(m_hComm);
					m_hComm = NULL;
					wsprintf( m_szComErrMsg, _T("SetCommState() failed! Error: %d"), GetLastError() );
					return 1;
				}
			}
			//check if the FAM has set to the max baudrate, but this program is re-start
			if( !bConnected &&  m_dwBaudrate != m_dwMaxBaudrate )
			{
				m_dcb.BaudRate = m_dwMaxBaudrate;
				if (SetCommState(m_hComm, &m_dcb))
				{
					wsprintf(szMsg, _T("Checking BaudRate - %d..."), m_dwMaxBaudrate);
					CFamShowMessage::PrintMessage(szMsg);
					if( CommunicateWithFAC( COMMAND_GET_VERSION, 0, 0, 0, RxCmd, NULL, NULL) != 0 )
					{
						CloseHandle(m_hComm);
						m_hComm = NULL;
						wcscpy_s(m_szComErrMsg, 128, _T("Try to communicate with FAC failed!"));
						return 1;
					}
					else
						bConnected = TRUE;
				}
				else
				{
					CloseHandle(m_hComm);
					m_hComm = NULL;
					wsprintf( m_szComErrMsg, _T("SetCommState() failed! Error: %d"), GetLastError() );
					return 1;
				}
				m_dwBaudrate = m_dwMaxBaudrate;
			}
			if( !bConnected )
			{						
				CloseHandle(m_hComm);
				m_hComm = NULL;
				wcscpy_s( m_szComErrMsg, 128, _T("Communicate with FAC failed! Please set the max baudrate OR reset the FAM!"));
				return 1;
			}
			// try to use the maximum baudrate to communicate with FAM
			if( m_dwBaudrate != m_dwMaxBaudrate )	
			{
				//first try to setcommstate tot he maximum baudrate to see if the PC COM port support or not
				m_dcb.BaudRate = m_dwMaxBaudrate;
				if (!SetCommState(m_hComm, &m_dcb))
				{
					CloseHandle(m_hComm);
					m_hComm = NULL;
					wsprintf( m_szComErrMsg, _T("SetCommState() failed! Error: %d"), GetLastError() );
					return 1;
				}
				m_dcb.BaudRate = m_dwBaudrate;
				if (!SetCommState(m_hComm, &m_dcb))
				{
					CloseHandle(m_hComm);
					m_hComm = NULL;
					wsprintf( m_szComErrMsg, _T("SetCommState() failed! Error: %d"), GetLastError() );
					return 1;
				}
				// if it is supported, change back to the previous baudrate and communicate to FAM to change the baudrate
				PurgeComm(m_hComm, PURGE_RXCLEAR | PURGE_TXCLEAR | PURGE_RXABORT | PURGE_TXABORT);
				//send command to change baudrate
				if( CommunicateWithFAC( 0x39, m_nFAMBaudrate, 0, 0, RxCmd, NULL, NULL) != 0 )
				{
					CloseHandle(m_hComm);
					m_hComm = NULL;
					wcscpy_s(m_szComErrMsg, 128, _T("Failed to change baudrate!"));
					return 1;
				}
				m_dwBaudrate = m_dwMaxBaudrate;
				m_dcb.BaudRate = m_dwMaxBaudrate;
				if (SetCommState(m_hComm, &m_dcb))
				{
					PurgeComm(m_hComm, PURGE_RXCLEAR | PURGE_TXCLEAR | PURGE_RXABORT | PURGE_TXABORT);
					if( CommunicateWithFAC( COMMAND_GET_VERSION, 0, 0, 0, RxCmd, NULL, NULL) != 0 )
					{
						CloseHandle(m_hComm);
						m_hComm = NULL;
						wcscpy_s( m_szComErrMsg, 128, _T("Try to communicate with FAC failed!") );
						return 1;
					}
				}
				else
				{
					CloseHandle(m_hComm);
					m_hComm = NULL;
					wsprintf( m_szComErrMsg, _T("SetCommState() failed! Error: %d"), GetLastError() );
					return 1;
				}
			}		
		}
		else
		{
			CloseHandle(m_hComm);
			m_hComm = NULL;
			wsprintf( m_szComErrMsg, _T("GetCommState() failed! Error: %d"), GetLastError() );
			return 1;
		}
	}
	else
	{
		CloseHandle(m_hComm);
		m_hComm = NULL;
		wsprintf( m_szComErrMsg, _T("SetCommState() failed! Error: %d"), GetLastError() );
		return 1;
	}

	//change the timeout
	m_CommTimeouts.ReadTotalTimeoutMultiplier = 1000;
	// configure
	if ( !SetCommTimeouts(m_hComm, &m_CommTimeouts) )
	{			
		CloseHandle(m_hComm);
		m_hComm = NULL;
		wsprintf( m_szComErrMsg, _T("SetCommState() failed! Error: %d"), GetLastError() );
		return 1;
	}

	m_bComError = FALSE;
	return 0;
}

void CFamSerialComm::CloseComPort()
{
	if (m_hComm != NULL)
	{
		CloseHandle(m_hComm);
		m_hComm = NULL;
	}
}

BYTE CFamSerialComm::CommunicateWithFAC(BYTE nCommand, UINT param1, UINT param2, BYTE nFlag, BYTE *RxCmd, BYTE *TxBuf, BYTE *RxBuf)
{
	BYTE CommandBuf[13] = { 0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0d } ; 
	UINT nChksum = 0;
	UINT nIndex;
	DWORD BytesSent = 0;
	DWORD BytesRead = 0;
	BYTE RxBufEndBytes[2];

	m_bComError = FALSE;

	CommandBuf[1] = nCommand;
	memcpy( CommandBuf+2, &param1, sizeof( int ) );
	memcpy( CommandBuf+6, &param2, sizeof( int ) );
	CommandBuf[10] = nFlag;
	for( nIndex=0; nIndex<11; nIndex++)
		nChksum += CommandBuf[nIndex];
	CommandBuf[11] = (BYTE) nChksum;

	CFamShowMessage::AddCommandList(0, CommandBuf);

	PurgeComm(m_hComm, PURGE_RXCLEAR | PURGE_TXCLEAR | PURGE_RXABORT | PURGE_TXABORT);

	// send data
	if( !WriteFile( m_hComm, CommandBuf, 13, &BytesSent, NULL) )
	{
		wsprintf( m_szComErrMsg, _T("WriteFile failed, error code : %d"), GetLastError() );
		m_bComError = TRUE;
		return 1;
	}
	if( BytesSent != 13 )
	{
		wsprintf( m_szComErrMsg, _T("WriteFile failed, BytesToSend is 13, BytesSent is %d"), BytesSent);
		m_bComError = TRUE;
		return 1;
	}

	if( TxBuf != NULL )
	{
		//checksum of data
		nChksum = 0;
		for( nIndex=0; nIndex<param2; nIndex++ )
			nChksum += TxBuf[nIndex];
		TxBuf[param2] = (BYTE) nChksum;	
		param2++;
		//if(!WriteFile( m_hComm, TxBuf, param2, &BytesSent, NULL))
		if( !WriteFileByBlock( m_hComm, TxBuf, param2, true ) )
		{
			return 1;
		}
	}
	// recv data
	memset( RxCmd, 0, 13 );
	if( !ReadFile( m_hComm,	RxCmd, 13, &BytesRead, NULL) )
	{
		wsprintf( m_szComErrMsg, _T("ReadFile failed, error code : %d"), GetLastError() );
		m_bComError = TRUE;
		return 1;
	}
	if( BytesRead != 13 )
	{
		wsprintf( m_szComErrMsg, _T("ReadFile failed, BytesToRead is 13, BytesRead is %d"), BytesRead);
		m_bComError = TRUE;
		return 1;
	}
	//
	CFamShowMessage::AddCommandList(1, RxCmd);
	CFamShowMessage::ShowCommandList();
	//
	if( RxCmd[10] == RET_OK )
	{
		if( nCommand == COMMAND_DOWNLOAD_RAW_IMAGE || nCommand == COMMAND_DOWNLOAD_FROM_FLASH 
			|| nCommand == COMMAND_DOWNLOAD_FROM_RAM || nCommand == COMMAND_DOWNLOAD_WSQ_IMAGE )
		{
			if( !ReadFileByBlock( m_hComm, RxBuf, param2, false ) )
				return 1;
			if(  !ReadFile( m_hComm,	RxBufEndBytes, 2, &BytesRead, NULL) )
				return 1;
		}
		else if( nCommand == COMMAND_DOWNLOAD_USER_LIST || nCommand == COMMAND_DOWNLOAD_TEMPLATE )
		{
			memcpy( &m_nRxDataLength, RxCmd+6, 4 );
			if( m_nRxDataLength > 0 )
			{
				if( m_pRxDataBuffer != NULL )
				{
					free( m_pRxDataBuffer );
					m_pRxDataBuffer = NULL;
				}
				m_pRxDataBuffer = (PBYTE)malloc( m_nRxDataLength + 2 );
				if( !ReadFileByBlock( m_hComm, m_pRxDataBuffer, m_nRxDataLength+2, FALSE ) )
				{
					return 1;
				}
			}
		}
		return 0;
	}

	if( RxCmd[10] == 0 )
		return RET_FLAG_ZERO;
	else
		return RxCmd[10];
}

BOOL CFamSerialComm::ReadFileByBlock( HANDLE hComm, LPBYTE lpBuffer, DWORD dwNumberOfBytesToRead, bool bShowPer )
{
	DWORD dwTotal = dwNumberOfBytesToRead;
	DWORD dwBytesToRead; 
	DWORD dwTotalBytesRead = 0;
	DWORD dwBytesRead;

	while( dwTotal > 0 )
	{
		if( dwTotal >= TRANSFER_BYTES_EACH_TIME )
			dwBytesToRead = TRANSFER_BYTES_EACH_TIME;
		else
			dwBytesToRead = dwTotal;
		if( !ReadFile( hComm, lpBuffer+dwTotalBytesRead, dwBytesToRead, &dwBytesRead, NULL) )
		{
			wsprintf( m_szComErrMsg, _T("ReadFile failed, error code : %d"), GetLastError() );
			m_bComError = TRUE;
			return FALSE;
		}
		if( dwBytesRead != dwBytesToRead )
		{
			wsprintf( m_szComErrMsg, _T("ReadFile failed, BytesToRead is %d, BytesRead is %d"),dwBytesToRead, dwBytesRead);
			m_bComError = TRUE;
			return FALSE;
		}
		dwTotal -= dwBytesRead;
		dwTotalBytesRead += dwBytesRead; 
		if( bShowPer )
		{
			TCHAR szPer[64];
			wsprintf( szPer, _T("Data receiving...%d%%"), (dwTotalBytesRead * 100)/(dwNumberOfBytesToRead));
			CFamShowMessage::PrintMessage( szPer );
		}
	}
	return TRUE;
}

BOOL CFamSerialComm::WriteFileByBlock( HANDLE hComm, LPBYTE lpBuffer, DWORD dwNumberOfBytesToWrite, bool bShowPer )
{
	DWORD dwTotal = dwNumberOfBytesToWrite;
	DWORD dwBytesToWrite; 
	DWORD dwTotalBytesWritten = 0;
	DWORD dwBytesWritten;

	while( dwTotal > 0 )
	{
		if( dwTotal >= TRANSFER_BYTES_EACH_TIME )
			dwBytesToWrite = TRANSFER_BYTES_EACH_TIME;
		else
			dwBytesToWrite = dwTotal;
		if( !WriteFile( hComm, lpBuffer+dwTotalBytesWritten, dwBytesToWrite, &dwBytesWritten, NULL) )
		{
			wsprintf( m_szComErrMsg, _T("WriteFile failed, error code : %d"), GetLastError() );
			m_bComError = TRUE;
			return FALSE;
		}
		if( dwBytesWritten != dwBytesToWrite )
		{
			wsprintf( m_szComErrMsg, _T("WriteFile failed, BytesToRead is %d, BytesRead is %d"),dwBytesToWrite, dwBytesWritten);
			m_bComError = TRUE;
			return FALSE;
		}
		dwTotal -= dwBytesWritten;
		dwTotalBytesWritten += dwBytesWritten; 
		if( bShowPer )
		{
			TCHAR szPer[64];
			wsprintf( szPer, _T("Data sending...%d%%"), (dwTotalBytesWritten * 100)/(dwNumberOfBytesToWrite));
			CFamShowMessage::PrintMessage( szPer );
		}
	}
	return TRUE;
}


BOOL CFamSerialComm::EnumerateComPorts()
{
	GUID guid = GUID_DEVINTERFACE_COMPORT;
	HDEVINFO hDevInfoSet = SetupDiGetClassDevs(&guid, NULL, NULL, DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);
	if (hDevInfoSet == INVALID_HANDLE_VALUE)
	{
		return FALSE;
	}

	//Finally do the enumeration
	BOOL bMoreItems = TRUE;
	int nIndex = 0;
	int nSelectedIndex = 0;
	SP_DEVINFO_DATA devInfo;
	int nPort;
	m_nNumComPort = 0;
	while (bMoreItems)
	{
		//Enumerate the current device
		devInfo.cbSize = sizeof(SP_DEVINFO_DATA);
		bMoreItems = SetupDiEnumDeviceInfo(hDevInfoSet, nIndex, &devInfo);
		if (bMoreItems)
		{
			//Did we find a serial port for this device
			BOOL bAdded = FALSE;
			//Get the registry key which stores the ports settings
			HKEY hDeviceKey = SetupDiOpenDevRegKey(hDevInfoSet, &devInfo, DICS_FLAG_GLOBAL, 0, DIREG_DEV, KEY_QUERY_VALUE);
			if (hDeviceKey)
			{
				//Read in the name of the port
				TCHAR pszPortName[256];
				DWORD dwSize = sizeof(pszPortName);
				DWORD dwType = 0;
				if ((RegQueryValueEx(hDeviceKey, _T("PortName"), NULL, &dwType, reinterpret_cast<LPBYTE>(pszPortName), &dwSize) == ERROR_SUCCESS) && (dwType == REG_SZ))
				{
					//If it looks like "COMX" then
					//add it to the array which will be returned
					size_t nLen = _tcslen(pszPortName);
					if (nLen > 3)
					{
						if ((_tcsnicmp(pszPortName, _T("COM"), 3) == 0) && (_istdigit(pszPortName[3])) )
						{
							//Work out the port number
							nPort = _ttoi(&pszPortName[3]);
							bAdded = TRUE;
						}
					}
				}
				//Close the key now that we are finished with it
				RegCloseKey(hDeviceKey);
			}
			//If the port was a serial port, then also try to get its friendly name
			if (bAdded)
			{
				TCHAR pszFriendlyName[128];
				DWORD dwSize = sizeof(pszFriendlyName);
				DWORD dwType = 0;
				wsprintf( m_arrEnumComPort[m_nNumComPort], _T("COM%d "), nPort);
				if (SetupDiGetDeviceRegistryProperty(hDevInfoSet, &devInfo, SPDRP_DEVICEDESC, &dwType, reinterpret_cast<PBYTE>(pszFriendlyName), dwSize, &dwSize) && (dwType == REG_SZ))
				   wcscat_s( m_arrEnumComPort[m_nNumComPort], dwSize, pszFriendlyName );
				m_nNumComPort ++;
			}
		}
		++nIndex;
	}
	//Free up the "device information set" now that we are finished with it
	SetupDiDestroyDeviceInfoList(hDevInfoSet);

	return TRUE;
}

UINT CFamSerialComm::GetDataBufferLength()
{
	return m_nRxDataLength;
}

BOOL CFamSerialComm::GetDataBuffer( BYTE *pDataBuffer )
{
	if( m_nRxDataLength == 0 )
		return FALSE;

	memcpy( pDataBuffer, m_pRxDataBuffer, m_nRxDataLength );
	return TRUE;
}


BOOL CFamSerialComm::IsComError()
{
	return m_bComError;
}

TCHAR * CFamSerialComm::GetComErrMsg()
{
	if( m_bComError )
		return m_szComErrMsg;
	return NULL;
}
