#pragma once
#include "FamDefs.h"

#define TRANSFER_BYTES_EACH_TIME	4096

class CFamSerialComm
{
public:
	CFamSerialComm(void);
	~CFamSerialComm(void);

	static TCHAR m_arrEnumComPort[20][128];	//maximum 20 com port
	static BYTE m_nNumComPort;
	static BOOL EnumerateComPorts();

	void SetComPort( TCHAR *szCom );
	void SetComDefaultBaudrate( DWORD dwBaudrate );
	void SetComMaxBaudrate( DWORD dwMaxBaudrate );
	BYTE PrepareComPort();
	void CloseComPort();
	BYTE CommunicateWithFAC(BYTE nCommand, UINT param1, UINT param2, BYTE nFlag, BYTE *RxCmd, BYTE *TxBuf, BYTE *RxBuf);
	BOOL IsComError();
	TCHAR * GetComErrMsg();
	UINT GetDataBufferLength();
	BOOL GetDataBuffer( BYTE *pDataBuffer );

private:
	BOOL ReadFileByBlock( HANDLE hComm, LPBYTE lpBuffer, DWORD dwNumberOfBytesToRead, bool bShowPer );
	BOOL WriteFileByBlock( HANDLE hComm, LPBYTE lpBuffer, DWORD dwNumberOfBytesToWrite, bool bShowPer );

	UINT m_nRxDataLength;
	BYTE *m_pRxDataBuffer;

	HANDLE m_hComm;
	COMMTIMEOUTS m_CommTimeouts;
	DCB	m_dcb;
	DWORD m_dwBaudrate;
	DWORD m_dwMaxBaudrate;
	TCHAR m_szComPort[32];
	UINT m_nFAMBaudrate;
	BOOL m_bComError;
	TCHAR m_szComErrMsg[128];
};
