#include "StdAfx.h"
#include "FamShowImage.h"

CFamShowImage::CFamShowImage(void)
{
	lpDIBHeader = NULL;
	lbDIBData = NULL;
	lpPal = NULL;
	hPGrayscale = NULL;
}

CFamShowImage::~CFamShowImage(void)
{
	if( lpPal != NULL )
		free( (void *)lpPal );
	if( lbDIBData != NULL )
		free( (void *)lbDIBData );
	if( lpDIBHeader != NULL )
		free( (void *)lpDIBHeader );
	if( hPGrayscale != NULL )
		DeleteObject( hPGrayscale );
}

BOOL CFamShowImage::PrepareView( int w, int h, int d )
{
	// support the 256-colors DIB only
	if( d != 8 ) return FALSE;

	// allocate memory for a DIB header
	if( (lpDIBHeader = (BITMAPINFO *)malloc( sizeof( BITMAPINFO ) +
											sizeof( RGBQUAD ) * 255 )) == NULL )
		return FALSE;
	ZeroMemory( (PVOID)lpDIBHeader, sizeof( BITMAPINFO ) + sizeof( RGBQUAD ) * 255 );

	// allocate memory for a DIB data
	if( (lbDIBData = (char *)malloc( sizeof( char ) * w * h )) == NULL )
	{
		free( (void *)lpDIBHeader );
		return FALSE; 
	}
	FillMemory( (PVOID)lbDIBData, sizeof( char ) * w * h, 0xFF );

	// allocate memory for a logical palette
	if( (lpPal = (LPLOGPALETTE)malloc( sizeof( LOGPALETTE ) +
									 sizeof( PALETTEENTRY ) * 255 )) == NULL )
	{
		free( (void *)lbDIBData );
		free( (void *)lpDIBHeader );
		return FALSE;
	}
	// fill the DIB header
	lpDIBHeader->bmiHeader.biSize          = sizeof( BITMAPINFOHEADER );
	lpDIBHeader->bmiHeader.biWidth         = w;
	lpDIBHeader->bmiHeader.biHeight        = h;
	lpDIBHeader->bmiHeader.biPlanes        = 1;
	lpDIBHeader->bmiHeader.biBitCount      = d;
	lpDIBHeader->bmiHeader.biCompression   = BI_RGB;

	// fill the logical palette
	lpPal->palVersion    = 0x300;
	lpPal->palNumEntries = 256;

	// initialize logical and DIB palettes to grayscale
	for(int iCyc = 0; iCyc < 256; iCyc++ )
	{
		lpDIBHeader->bmiColors[iCyc].rgbBlue = lpDIBHeader->bmiColors[iCyc].rgbGreen =
		lpDIBHeader->bmiColors[iCyc].rgbRed = lpPal->palPalEntry[iCyc].peBlue =
		lpPal->palPalEntry[iCyc].peGreen = lpPal->palPalEntry[iCyc].peRed = (BYTE)iCyc;
	}

	// create a grayscale palette
	if( (hPGrayscale = CreatePalette( lpPal )) == NULL )
	{
		free( (void *)lpPal );
		free( (void *)lbDIBData );
		free( (void *)lpDIBHeader );
		return FALSE;
	}

	// set BITMAPFILEHEADER structure
	((char *)(&bmfHeader.bfType))[0] = 'B';
	((char *)(&bmfHeader.bfType))[1] = 'M';
	bmfHeader.bfSize = sizeof( BITMAPFILEHEADER ) + sizeof( BITMAPINFO ) + sizeof( RGBQUAD ) * 255
	  + sizeof( char ) * w * h;

	bmfHeader.bfOffBits = (DWORD)sizeof(BITMAPFILEHEADER) + lpDIBHeader->bmiHeader.biSize
											  + sizeof( RGBQUAD ) * 256;

	// normal return
	return TRUE;
}

void CFamShowImage::DIBShow(HDC hdcImage, BYTE *pImage)
{
	char  *cptrData;
	char  *cptrDIBData;

	// rotate an image while copying data to the DIB data
	cptrData = (char *)pImage + (lpDIBHeader->bmiHeader.biHeight - 1) *
				  lpDIBHeader->bmiHeader.biWidth;

	cptrDIBData = lbDIBData;
	for( int iCyc = 0; iCyc < lpDIBHeader->bmiHeader.biHeight; iCyc++ )
	{
		memcpy( cptrDIBData, cptrData, lpDIBHeader->bmiHeader.biWidth );
		cptrData = cptrData - lpDIBHeader->bmiHeader.biWidth;
		cptrDIBData = cptrDIBData + lpDIBHeader->bmiHeader.biWidth;
	}

	// show the fingerprint image
	SelectPalette( hdcImage, hPGrayscale, FALSE );
	RealizePalette( hdcImage );
	SetDIBitsToDevice(
		hdcImage,
		0,
		0,
		320,
		480,
		0,
		0,
		0,
		lpDIBHeader->bmiHeader.biHeight,
		lbDIBData,                       // address of array with DIB bits
		lpDIBHeader,                     // address of structure with bitmap info
		DIB_RGB_COLORS);						  // RGB or palette indices
}

void CFamShowImage::WriteBMPFile(TCHAR *szPath, BYTE *pImage)
{
	int   iCyc;
	char  *cptrData;
	char  *cptrDIBData;

	FILE *fptr = NULL;
	_wfopen_s( &fptr, szPath, _T("wb") );
	if( fptr == NULL )
	{
		MessageBox(NULL, _T("Failed to open the file!"), _T("Write bitmap file"), MB_OK|MB_ICONSTOP);
		return;
	}
	cptrData = (char *)pImage + (lpDIBHeader->bmiHeader.biHeight - 1) * lpDIBHeader->bmiHeader.biWidth;
	cptrDIBData = lbDIBData;
	for( iCyc = 0; iCyc < lpDIBHeader->bmiHeader.biHeight; iCyc++ )
	{
	  memcpy( cptrDIBData, cptrData, lpDIBHeader->bmiHeader.biWidth );
	  cptrData = cptrData - lpDIBHeader->bmiHeader.biWidth;
	  cptrDIBData = cptrDIBData + lpDIBHeader->bmiHeader.biWidth;
	}
	fwrite( (void *)&bmfHeader, sizeof(BITMAPFILEHEADER), 1, fptr );
	fwrite( (void *)lpDIBHeader, sizeof( BITMAPINFO ) + sizeof( RGBQUAD ) * 255, 1, fptr );
	fwrite( (void *)lbDIBData, lpDIBHeader->bmiHeader.biWidth * lpDIBHeader->bmiHeader.biHeight, 1, fptr );
	fclose(fptr);
}
