#include "StdAfx.h"
#include "FamShowMessage.h"

HWND CFamShowMessage::m_hwndMsg = NULL;
HWND CFamShowMessage::m_hwndCmd = NULL;
BYTE CFamShowMessage::m_nCountOfCommandLists = 0;
TCHAR CFamShowMessage::m_szMsgCommands[MAX_COMMAND_MESSAGE][64];

CFamShowMessage::CFamShowMessage(void)
{
}

CFamShowMessage::~CFamShowMessage(void)
{
}

void CFamShowMessage::SetWndMsg( HWND hwndMsg )
{
	m_hwndMsg = hwndMsg;
}

void CFamShowMessage::SetWndCmd( HWND hwndCmd )
{	
	m_hwndCmd = hwndCmd;
}

void CFamShowMessage::ResetCountOfCommandList()
{
	m_nCountOfCommandLists = 0;
}

void CFamShowMessage::AddCommandList(BYTE nFlag, BYTE *pCommand)
{
	TCHAR szFlag[5];

	if( nFlag == 0 )
		wcscpy_s(szFlag, 5, _T("Host"));
	else
		wcscpy_s(szFlag, 5, _T("FAM"));

	if( m_nCountOfCommandLists < MAX_COMMAND_MESSAGE )
	{
		wsprintf(m_szMsgCommands[m_nCountOfCommandLists], _T("%s: %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X"), 
			szFlag, pCommand[0], pCommand[1], pCommand[2], pCommand[3], pCommand[4], pCommand[5], pCommand[6], 
			pCommand[7], pCommand[8], pCommand[9], pCommand[10], pCommand[11], pCommand[12] );	
		m_nCountOfCommandLists ++;
	}
	else
	{
		for( int nCyc=0; nCyc<MAX_COMMAND_MESSAGE-1; nCyc++ )
		{
			wcscpy_s( m_szMsgCommands[nCyc], 64, m_szMsgCommands[nCyc+1] );
		}
		wsprintf(m_szMsgCommands[MAX_COMMAND_MESSAGE-1], _T("%s: %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X"), 
			szFlag, pCommand[0], pCommand[1], pCommand[2], pCommand[3], pCommand[4], pCommand[5], pCommand[6], 
			pCommand[7], pCommand[8], pCommand[9], pCommand[10], pCommand[11], pCommand[12] );	
	}
}

void CFamShowMessage::ShowCommandList()
{
	if( m_nCountOfCommandLists > 0 && m_hwndCmd != NULL )
	{
		TCHAR szCommandList[MAX_COMMAND_MESSAGE*64] = _T("");
		for( int i=0; i<m_nCountOfCommandLists; i++ )
		{
			wcscat_s( szCommandList, MAX_COMMAND_MESSAGE*64, m_szMsgCommands[i] );
			wcscat_s( szCommandList, MAX_COMMAND_MESSAGE*64, _T("\r\n") );
		}
		::SetWindowText( m_hwndCmd, szCommandList );
		::UpdateWindow( m_hwndCmd );
	}
}

void CFamShowMessage::PrintMessage( TCHAR *pMsg )
{
	::SetWindowText( m_hwndMsg, pMsg );
}

