#include "StdAfx.h"
#include "FamSocketComm.h"
#include "FamShowMessage.h"

CFamSocketComm::CFamSocketComm(void)
{
	WSADATA wsaData;
	if (WSAStartup(0x202,&wsaData) == SOCKET_ERROR) 
		MessageBox(NULL, _T("WSAStartup failed!"), 0, MB_OK|MB_ICONSTOP);
	m_nRxDataLength = 0;
	m_pRxDataBuffer = NULL;
	m_dwIP = 0;
	m_nPort = 0;
}

CFamSocketComm::~CFamSocketComm(void)
{
	WSACleanup();
	if( m_pRxDataBuffer != NULL )
	{
		free( m_pRxDataBuffer );
		m_pRxDataBuffer = NULL;
	}
}

void CFamSocketComm::SetSocketIP( DWORD dwIP )
{
	m_dwIP = dwIP;
}

void CFamSocketComm::SetSocketPort( UINT nPort )
{
	m_nPort = nPort;
}

BYTE CFamSocketComm::PrepareSocket()
{
	fd_set write_fds;
	struct sockaddr_in server;
	unsigned long ioctl_opt = 1;
	int nSel;
	struct timeval tv;
	tv.tv_sec = 3;
	tv.tv_usec = 0;

	m_sck = socket(AF_INET, SOCK_STREAM,0); // TCP socket
	if (m_sck == INVALID_SOCKET)
		return RET_WINSOCK_ERROR;

	// Set the socket to non_blocking mode.
	if (ioctlsocket(m_sck, FIONBIO, &ioctl_opt) == SOCKET_ERROR)
		return RET_WINSOCK_ERROR;

	//addr = inet_addr("192.168.0.30");
	memset(&server,0,sizeof(server));
	//memcpy(&(server.sin_addr), &addr, 4);
	server.sin_addr.S_un.S_un_b.s_b1 = (BYTE) (m_dwIP >> 24);
	server.sin_addr.S_un.S_un_b.s_b2 = (BYTE) (m_dwIP >> 16);
	server.sin_addr.S_un.S_un_b.s_b3 = (BYTE) (m_dwIP >> 8);
	server.sin_addr.S_un.S_un_b.s_b4 = (BYTE) m_dwIP;
	server.sin_family = 2;
	server.sin_port = htons( m_nPort );

	FD_ZERO( &write_fds );	// clear the write_fds and temp sets
	FD_SET( m_sck, &write_fds );

	if( connect(m_sck, (struct sockaddr*)&server, sizeof(server)) == SOCKET_ERROR )
	{
		if( WSAGetLastError() == WSAEWOULDBLOCK )
		{
			nSel = select((int)m_sck+1, NULL, &write_fds, NULL, &tv);
			if( nSel == SOCKET_ERROR ) // Error
			{
				closesocket(m_sck);
				return RET_WINSOCK_ERROR;
			}
			else if( nSel == 0 )	// TimeOut
			{
				closesocket(m_sck);
				return RET_CONNECT_TIMEOUT;
			}
		}
		else
		{
			closesocket(m_sck);
			return RET_WINSOCK_ERROR;
		}
	}
	return 0;
}

void CFamSocketComm::CloseSocket()
{
	closesocket(m_sck);
}

BYTE CFamSocketComm::CommunicateWithFAC(BYTE nCommand, UINT param1, UINT param2, BYTE nFlag, BYTE *RxCmd, BYTE *TxBuf, BYTE *RxBuf)
{
	BYTE CommandBuf[13] = { 0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0d } ; 
	UINT nChksum = 0;
	UINT nIndex;
	fd_set current_read_fds;
	int nSel;
	struct timeval tv;
	int nRecv;

	tv.tv_sec = 10;		// 10sec timeout for waiting to recv()
	tv.tv_usec = 0;

	CommandBuf[1] = nCommand;
	memcpy( CommandBuf+2, &param1, sizeof( int ) );
	memcpy( CommandBuf+6, &param2, sizeof( int ) );
	CommandBuf[10] = nFlag;
	for( nIndex=0; nIndex<11; nIndex++)
		nChksum += CommandBuf[nIndex];
	CommandBuf[11] = (BYTE) nChksum;

	CFamShowMessage::AddCommandList(0, CommandBuf);

	// send data
	if( send(m_sck, (char *)CommandBuf, 13, 0) == -1 )
		return RET_WINSOCK_ERROR;
	if( TxBuf != NULL )
	{
		//checksum of data
		nChksum = 0;
		for( nIndex=0; nIndex<param2; nIndex++ )
			nChksum += TxBuf[nIndex];
		TxBuf[param2] = (BYTE) nChksum;	
		param2++;
		if( sendall(m_sck, (char *)TxBuf, &param2 ) == -1 )
			return RET_WINSOCK_ERROR;
	}
	// receive data
	FD_ZERO(&current_read_fds);	// clear the read_fds and temp sets
	FD_SET( m_sck, &current_read_fds );	// add socket s to the current read fds
	nSel = select((int)m_sck+1, &current_read_fds, NULL, NULL, &tv);
	if( nSel == -1 )		// Error
		return WSAGetLastError();
	else if( nSel == 0 )	// TimeOut
		return RET_RXD_TIMEOUT;
	// recv data
	memset( RxCmd, 0, 13 );
	nRecv = recv(m_sck, (char *)RxCmd, 13, 0);
	if (nRecv <= 0)
		return RET_WINSOCK_ERROR;
	//
	CFamShowMessage::AddCommandList(1, RxCmd);
	CFamShowMessage::ShowCommandList();

	if( RxCmd[10] == RET_OK )
	{
		if( nCommand == COMMAND_DOWNLOAD_RAW_IMAGE || nCommand == COMMAND_DOWNLOAD_FROM_FLASH 
			|| nCommand == COMMAND_DOWNLOAD_FROM_RAM || nCommand == COMMAND_DOWNLOAD_WSQ_IMAGE )	
		{
			nRecv = recvall(m_sck, (char *)RxBuf, param2+2 );
			if (nRecv != 0)
				return RET_WINSOCK_ERROR;
		}
		else if( nCommand == COMMAND_DOWNLOAD_USER_LIST || nCommand == COMMAND_DOWNLOAD_TEMPLATE )
		{
			memcpy( &m_nRxDataLength, RxCmd+6, 4 );
			if( m_nRxDataLength > 0 )
			{
				if( m_pRxDataBuffer != NULL )
				{
					free( m_pRxDataBuffer );
					m_pRxDataBuffer = NULL;
				}
				m_pRxDataBuffer = (PBYTE)malloc( m_nRxDataLength + 2 );
				nRecv = recvall(m_sck, (char *)m_pRxDataBuffer, m_nRxDataLength + 2 );
				if( nRecv != 0 )
					return RET_WINSOCK_ERROR;
			}
		}
		return 0;
	}

	if( RxCmd[10] == 0 )
		return RET_FLAG_ZERO;
	else
		return RxCmd[10];
}



/*******************************************************************************
 * sendall: send all the data with len
 *******************************************************************************/
int CFamSocketComm::sendall(SOCKET s, char *buf, UINT *len)
{
	UINT total=0;
	UINT bytesleft = *len;
	UINT n;
	struct timeval tWait;
	int nSel;
	tWait.tv_sec = 5;
	tWait.tv_usec = 0;
	fd_set write_fds;

	FD_ZERO( &write_fds );
	FD_SET( (UINT) s, &write_fds );		// add sockets to the write fds
	nSel = select((int)s+1, NULL, &write_fds, NULL, &tWait);
	if( nSel == -1 || nSel == 0 ) // Error || TimeOut
		return -1;

	while( total < *len )
	{
		n = send(s, buf+total, bytesleft, 0);
		if( n== -1 )
			break;
		total += n;
		bytesleft -= n;
		if( total < *len )
		{
			nSel = select((int)s+1, NULL, &write_fds, NULL, &tWait);
			if( nSel == -1 || nSel == 0 ) // Error || TimeOut
				return -1;
		}
	}
	*len = total;
	FD_CLR( (UINT) s, &write_fds );
	return n==-1?-1:0;
}
/*******************************************************************************
 * recvall: recv all the data with len
 *******************************************************************************/
int CFamSocketComm::recvall(SOCKET s, char *buf, UINT len)
{
	UINT total=0;
	UINT bytesleft = len;
	UINT n=0;
	struct timeval tWait;
	int nSel;
	tWait.tv_sec = 5;
	tWait.tv_usec = 0;
	char szMsg[1];
	fd_set current_read_fds;

	szMsg[0] = 0;
	FD_ZERO( &current_read_fds );
	FD_SET( (UINT) s, &current_read_fds );		// add socket s to the current read fds

	nSel = select((int)s+1, &current_read_fds, NULL, NULL, &tWait);
	if( nSel == -1 || nSel == 0 )		// Error || TimeOut
		return -1;

	while( total < len )
	{
		n = recv(s, buf+total, bytesleft, 0);
		if( n== -1 )
			break;
		total += n;
		bytesleft -= n;
		if( total < len )
		{
			// Send 1byte to FAM for acknowledge, FAM will skip this byte if don't wait input data
			// 
			send(s, szMsg, 1, 0);
			nSel = select((int)s+1, &current_read_fds, NULL, NULL, &tWait);
			if( nSel == -1 || nSel == 0 ) // Error || TimeOut
				return -1;
		}
	}
	FD_CLR( (UINT) s, &current_read_fds );
	return n==-1?-1:0;
}

UINT CFamSocketComm::GetDataBufferLength()
{
	return m_nRxDataLength;
}

BOOL CFamSocketComm::GetDataBuffer( BYTE *pDataBuffer )
{
	if( m_nRxDataLength == 0 )
		return FALSE;

	memcpy( pDataBuffer, m_pRxDataBuffer, m_nRxDataLength );
	return TRUE;
}
