#include "stdafx.h"
#include "EthFamEx.h"
#include "EthFamExDlg.h"
#include "FamDefs.h"

#define		GET_IMAGE_BYTES_EACH_TIME		1600
#define		RAW_IMAGE_SIZE							153600    //320*480

extern CFamComm commFam;

BOOL GetRawImageByLines(LPVOID data)
{
	if (data==NULL) 
		return FALSE;

	CEthFamExDlg *pEx = (CEthFamExDlg *)data;
	UINT nOffset = 0;
	BYTE nTimesRetry = 0;
    UINT nTotal = RAW_IMAGE_SIZE;
    UINT nImgSize = 0;
	BYTE nRet = 0;
	CString strPerMsg;

    while(nTotal > 0)
    {
        nImgSize = GET_IMAGE_BYTES_EACH_TIME;
        if (nTotal < nImgSize)
            nImgSize = nTotal;
		nRet = commFam.FamDownloadRAWImage_Size_Offset( pEx->m_pImage+nOffset, nImgSize, nOffset );
		if( nRet != 0 )
		{
			nTimesRetry ++;
			if( nTimesRetry > 2 )
			{
				return FALSE;
			}
			Sleep(20);
			continue;
		}
		nTimesRetry = 0;
		nOffset += nImgSize;
		nTotal -= nImgSize;
		strPerMsg.Format( _T("Data receiving...%d%%"), (nOffset * 100) / RAW_IMAGE_SIZE );
		pEx->PrintMessage(strPerMsg);
	}
	return TRUE;
}

// this is the worker thread function.
UINT CaptureThreadFunc(LPVOID data)
{
	if (data==NULL) 
	{
		AfxEndThread(0);
	}

	CEthFamExDlg *pEx = (CEthFamExDlg *)data;
	BYTE nRet;
	UINT nContrast = 0;
	UINT nBrightness = 0;

	pEx->m_bRunning = true;
	pEx->bCancel = false;
	
	if( commFam.PrepareConnection() != 0 )
	{
		pEx->PrintErrorMessage();
		pEx->EnableControl(true);
		return 0;
	}
	pEx->PrintMessage(_T("Put your finger on the FAM") );

	while( !pEx->bCancel )
	{
		nRet = commFam.FamIsFingerPresent();
		if( nRet == 0 )
			break;
		else if( nRet != RET_NO_IMAGE )
		{
			pEx->PrintErrorMessage();
			commFam.CloseConnection();
			pEx->EnableControl(true);
			return 0;
		}
		Sleep(50);
	}
	if( pEx->bCancel )
	{
		pEx->PrintMessage(_T("Cancel by user!"));
	}
	else
	{
		nRet = commFam.FamCaptureImage(pEx->m_bPIV, &nContrast, &nBrightness);
		if( nRet == 0 )
		{
			DWORD dwT1 = GetTickCount();
			DWORD dwT2;
			if( pEx->m_bWSQ )
			{
				BYTE nBitrate = 0x4B;		// range 0x4B - 0xFF
				UINT nWsqSize = 0;
				nRet = commFam.FamConvertRawToWsq( nBitrate, nWsqSize );
				if( nRet == 0 && nWsqSize > 0 )
				{
					dwT2 = GetTickCount();
					PBYTE pWsqImage = new BYTE[nWsqSize];
					nRet =  commFam.FamDownloadWSQImage( pWsqImage, nWsqSize );
					if( nRet == 0 )
					{
						CString strMsg;
						strMsg.Format( _T("Capture WSQ image successfully! T1=%d(ms), T2=%d(ms)"), dwT2-dwT1, GetTickCount()-dwT2 );
						pEx->PrintMessage(strMsg);
					}
					else
						pEx->PrintErrorMessage();
					delete [] pWsqImage;
				}
				else
					pEx->PrintErrorMessage();
			}
			else
			{
				if( GetRawImageByLines( pEx ) )
				{
					pEx->DIBShow();
					if( !pEx->m_bCapture2Screen )
						pEx->WriteBMPFile();
					else
					{
						CString strMsg;
						strMsg.Format( _T("Capture image successfully! T=%d(ms), C=%u, B=%u"), GetTickCount()-dwT1, nContrast, nBrightness );
						pEx->PrintMessage(strMsg);
					}
				}
				else
					pEx->PrintErrorMessage();
			}
		}
		else
			pEx->PrintErrorMessage();
	}
	commFam.CloseConnection();
	pEx->EnableControl(true);
	return 0;
}

UINT IdentifyThreadFunc(LPVOID data)
{
	if (data==NULL) 
	{
		AfxEndThread(0);
	}

	CEthFamExDlg *pEx = (CEthFamExDlg *)data;

	BYTE nRet;
	UINT nID_L, nID_H;
	UINT nContrast = 0;
	UINT nBrightness = 0;

	pEx->m_bRunning = true;
	pEx->bCancel = false;
	if( commFam.PrepareConnection() != 0 )
	{
		pEx->PrintErrorMessage();
		pEx->EnableControl(true);
		return 1;
	}
	pEx->PrintMessage(_T("Put your finger on the FAM"));
	while( !pEx->bCancel )
	{
		nRet = commFam.FamIsFingerPresent( );
		if( nRet == 0 )
			break;
		else if( nRet != RET_NO_IMAGE )
		{
			pEx->PrintErrorMessage();
			commFam.CloseConnection();
			return 1;
		}
		Sleep(50);
	}
	if( pEx->bCancel )
	{
		pEx->PrintMessage(_T("Cancel by user!"));
	}
	else
	{
		nRet = commFam.FamCaptureImage(pEx->m_bPIV, &nContrast, &nBrightness);
		if( nRet == 0 )
		{
			if( pEx->m_bShowImage )
			{
				if( GetRawImageByLines( pEx ) )
					nRet = 0;
				else
					nRet = 1;
			}
			if( nRet == 0 )
			{
				if( pEx->m_bShowImage )
				{
					pEx->DIBShow();
				}
				nRet = commFam.FamProcessImage( );
				if( nRet == 0 )
				{
					pEx->PrintMessage(_T("Matching......"));
					DWORD dwT1, dwT2;
					dwT1 = GetTickCount();
					nRet = commFam.FamIdentify( &nID_L, &nID_H);
					if( nRet == 0 )
					{ 
						dwT2 = GetTickCount();
						unsigned __int64 ui64UID; 
						BYTE nGroupID;
						BYTE nFingerID;
						nGroupID = nID_H >> 24;
						nFingerID = nID_H >> 16;
						nID_H = nID_H & 0xFFFF;	
						ui64UID = nID_L + (nID_H * 0x100000000);
						pEx->m_strMessage.Format(_T("Matched! GID:%d, FID:%d, UID:%I64u.  Time: %d (ms)"),nGroupID, nFingerID, ui64UID, dwT2-dwT1);
						pEx->PrintMessage(pEx->m_strMessage);
					}
					else
						pEx->PrintErrorMessage();
				}
				else
					pEx->PrintErrorMessage();
			}
			else
				pEx->PrintErrorMessage( );
		}
		else
			pEx->PrintErrorMessage();
	}
	pEx->EnableControl(true);
	commFam.CloseConnection();
	return 0;
}

UINT EnrollThreadFunc(LPVOID data)
{
	if (data==NULL) 
	{
		AfxEndThread(0);
	}

	CEthFamExDlg *pEx = (CEthFamExDlg *)data;

	BYTE nRet = 0;
	BYTE ncyc;
	bool bError = false;
	UINT nContrast = 0;
	UINT nBrightness = 0;

	pEx->m_bRunning = true;
	pEx->bCancel = false;
	if( commFam.PrepareConnection() != 0 )
	{
		pEx->PrintErrorMessage();
		pEx->EnableControl(true);
		return 1;
	}
	ncyc = 0;
	pEx->m_ctrlProgress.ShowWindow( SW_SHOW );
	pEx->m_ctrlProgress.SetPos(ncyc);
	pEx->UpdateWindow(); 
	while( !pEx->bCancel )
	{
		pEx->PrintMessage(_T("Put your finger on the FAM"));
		while( !pEx->bCancel )
		{
			nRet = commFam.FamIsFingerPresent( );
			if( nRet == 0 )
				break;
			else if( nRet != RET_NO_IMAGE )
			{
				pEx->PrintErrorMessage();
				bError = true;
				break;
			}
			Sleep(50);
		}
		if( pEx->bCancel || bError )
			break;
		nRet = commFam.FamCaptureImage(pEx->m_bPIV, &nContrast, &nBrightness);
		if( nRet == 0 )
		{
			if( pEx->m_bShowImage )
			{
				if( GetRawImageByLines( pEx ) )
					nRet = 0;
				else
					nRet = 1;
			}
			if( nRet == 0 )
			{
				if( pEx->m_bShowImage )
				{
					pEx->DIBShow();
				}
				nRet = commFam.FamProcessImage( );
				if( nRet == 0 )
				{
					nRet = commFam.FamStoreSample(ncyc);
					if( nRet == 0 )
					{ 
						ncyc++;
						pEx->m_ctrlProgress.SetPos(ncyc);
						if( ncyc == pEx->m_nMaxSample )
							break;
					}
					else
					{
						pEx->PrintErrorMessage();
						bError = true;
						break;
					}
				}
				else if( nRet == RET_BAD_QUALITY || nRet == RET_TOO_LITTLE_POINTS )
				{
					// 0x42 -> Bad quality 0x43->Too little points
					pEx->PrintErrorMessage();
					Sleep(1500);
				}
				else
				{
					pEx->PrintErrorMessage();
					bError = true;
					break;
				}
			}
			else
			{
				pEx->PrintErrorMessage( );
				bError = true;
				break;
			}
		}
		else
		{
			pEx->PrintErrorMessage( );
			bError = true;
			break;
		}
		//
		pEx->PrintMessage(_T("Take your finger off the FAM"));
		while( !pEx->bCancel )
		{
			nRet = commFam.FamIsFingerPresent();
			if( nRet == RET_NO_IMAGE )
				break;
			else if( nRet != 0 )
			{
				pEx->PrintErrorMessage( );
				bError = true;
				break;
			}
			Sleep(50);
		}
	}
	if( !pEx->bCancel && !bError )
	{
		nRet = commFam.FamStoreTemplate( pEx->m_nIDL, pEx->m_nIDH, pEx->m_nUType );
		if( nRet == 0 )
		{
			pEx->PrintMessage(_T("Enroll user successully!"));
		}
		else
			pEx->PrintErrorMessage( );
	}
	else if( pEx->bCancel )
	{
		pEx->PrintMessage(_T("Cancel by user!"));
	}
	pEx->m_ctrlProgress.ShowWindow(SW_HIDE);
	commFam.CloseConnection();
	pEx->EnableControl(true);
	return 0;
}


UINT VerifyThreadFunc(LPVOID data)
{
	if (data==NULL) 
	{
		AfxEndThread(0);
	}

	CEthFamExDlg *pEx = (CEthFamExDlg *)data;
	BYTE nRet = 0;
	UINT nContrast = 0;
	UINT nBrightness = 0;

	pEx->m_bRunning = true;
	pEx->PrintMessage(_T("Put your finger on the FAM"));
	while( !pEx->bCancel )
	{
		nRet = commFam.FamIsFingerPresent( );
		if( nRet == 0 )
			break;
		else if( nRet != RET_NO_IMAGE )
		{
			pEx->PrintErrorMessage();
			commFam.CloseConnection();
			pEx->EnableControl(true);
			return 1;
		}
		Sleep(50);
	}
	if( pEx->bCancel)
	{
		pEx->PrintMessage(_T("Cancel by user!"));
	}
	else
	{
		nRet = commFam.FamCaptureImage(pEx->m_bPIV, &nContrast, &nBrightness );
		if( nRet == 0 )
		{
			if( pEx->m_bShowImage )
			{
				if( GetRawImageByLines( pEx ) )
					nRet = 0;
				else
					nRet = 1;
			}
			if( nRet == 0 )
			{
				if( pEx->m_bShowImage )
				{
					pEx->DIBShow();
				}
				nRet = commFam.FamProcessImage( );
				if( nRet == 0 )
				{
					nRet = commFam.FamVerify( pEx->m_nIDL, pEx->m_nIDH);
					if( nRet == 0 )
					{ 
						pEx->PrintMessage(_T("Verify OK!"));
					}
					else
						pEx->PrintErrorMessage();
				}
				else
					pEx->PrintErrorMessage();
			}
			else
				pEx->PrintErrorMessage( );
		}
		else
			pEx->PrintErrorMessage();
	}
	commFam.CloseConnection();
	pEx->EnableControl(true);
	return 0;
}