// DlgUserList.cpp : implementation file
//

#include "stdafx.h"
#include "EthFamEx.h"
#include "DlgUserList.h"


// CDlgUserList dialog

IMPLEMENT_DYNAMIC(CDlgUserList, CDialog)

CDlgUserList::CDlgUserList(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgUserList::IDD, pParent)
{
	m_nID_L = m_nID_H = 0;
}

CDlgUserList::~CDlgUserList()
{
}

void CDlgUserList::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_USER, m_listUser);
	DDX_Control(pDX, IDC_COMBO_UTYPE, m_ctrlUType);
	DDX_Control(pDX, IDC_COMBO_SL, m_ctrlSL);
	DDX_Control(pDX, IDC_TEXT_UID, m_ctrlUID);
	DDX_Control(pDX, IDC_LBL_UID, m_lblUID);
	DDX_Control(pDX, IDC_LBL_TOTAL, m_ctrlTotal);
	DDX_Control(pDX, IDC_TEXT_GID, m_ctrlGID);
	DDX_Control(pDX, IDC_TEXT_FINGERID, m_ctrlFID);
	DDX_Control(pDX, IDC_LBL_GID, m_lblGID);
	DDX_Control(pDX, IDC_LBL_FID, m_lblFID);
	DDX_Control(pDX, IDC_LBL_UTYPE, m_lblUType);
	DDX_Control(pDX, IDC_LBL_STATUS, m_lblStatus);
	DDX_Control(pDX, IDC_COMBO_STATUS, m_ctrlStatus);
	DDX_Control(pDX, IDC_LBL_SL, m_lblSL);
	DDX_Control(pDX, IDC_GB_CHANGE, m_gbChange);
}


BEGIN_MESSAGE_MAP(CDlgUserList, CDialog)
	ON_BN_CLICKED(IDOK, &CDlgUserList::OnBnClickedOk)
ON_NOTIFY(NM_DBLCLK, IDC_LIST_USER, &CDlgUserList::OnNMDblclkListUser)
ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_USER, &CDlgUserList::OnLvnItemchangedListUser)
END_MESSAGE_MAP()


// CDlgUserList message handlers

BOOL CDlgUserList::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_listUser.SetExtendedStyle( LVS_EX_FULLROWSELECT );
	m_listUser.InsertColumn(0, _T("Group ID"), LVCFMT_LEFT, 60);
	m_listUser.InsertColumn(1, _T("User ID"), LVCFMT_LEFT, 120);
	m_listUser.InsertColumn(2, _T("Finger ID"), LVCFMT_LEFT, 60);
	m_listUser.InsertColumn(3, _T("User Type"), LVCFMT_LEFT, 70);
	m_listUser.InsertColumn(4, _T("Status"), LVCFMT_LEFT, 60);
	m_listUser.InsertColumn(5, _T("Security Level"), LVCFMT_LEFT, 90);

	UINT nTotalUser = m_nLength/12;
	PFAMUSER pUser;
	UINT nIDL, nIDH;

	CString strTotal;
	strTotal.Format(_T("%d"), nTotalUser);
	m_ctrlTotal.SetWindowTextW( strTotal );

	pUser = (PFAMUSER) malloc( nTotalUser * sizeof( FAMUSER ) );

	UINT i, j;
	for( i=0; i<nTotalUser; i++ )
	{
		nIDH = 0;
		memcpy(&nIDL, m_pUList+i*12, 4);
		memcpy(&nIDH, m_pUList+i*12+4, 2);
		pUser[i].FingerID = m_pUList[i*12+6];
		pUser[i].GroupID = m_pUList[i*12+7];
		pUser[i].UserType = m_pUList[i*12+8];
		pUser[i].UserID =  nIDL + nIDH*0x100000000;
	}
	// sort the user list
	FAMUSER tmpUser;
	for( i=0; i<nTotalUser-1; i++ )
	{
		for( j=i+1; j<nTotalUser; j++ )
		{
			if( pUser[i].UserID > pUser[j].UserID )
			{
				tmpUser.GroupID = pUser[i].GroupID;
				tmpUser.FingerID = pUser[i].FingerID;
				tmpUser.UserID = pUser[i].UserID;
				tmpUser.UserType = pUser[i].UserType;
				pUser[i].GroupID = pUser[j].GroupID;
				pUser[i].FingerID = pUser[j].FingerID;
				pUser[i].UserID = pUser[j].UserID;
				pUser[i].UserType = pUser[j].UserType;
				pUser[j].GroupID = tmpUser.GroupID;
				pUser[j].FingerID = tmpUser.FingerID;
				pUser[j].UserID = tmpUser.UserID;
				pUser[j].UserType = tmpUser.UserType;
			}
		}
	}
	CString strUID;
	CString strGID;
	CString strFID;
	CString strUType;
	CString strStatus;
	CString strSL;
	UINT nItem = 0;
	BYTE nType;
	for( i=0; i<nTotalUser; i++ )
	{
		strGID.Format(_T("%d"), pUser[i].GroupID);
		strUID.Format(_T("%I64u"), pUser[i].UserID );
		strFID.Format(_T("%d"), pUser[i].FingerID);
		nType = pUser[i].UserType;
		if( nType & 0x04 )
			strUType = _T("VIP");
		else
			strUType = _T("Ordinary");
		if( nType & 0x08 )
			strStatus = _T("Suspend");
		else
			strStatus = _T("Active");
		nType = nType & 0x03;
		strSL.Format(_T("%d"),nType);

		m_listUser.InsertItem(nItem, strGID);
		m_listUser.SetItemText(nItem, 1, strUID);
		m_listUser.SetItemText(nItem, 2, strFID);
		m_listUser.SetItemText(nItem, 3, strUType);
		m_listUser.SetItemText(nItem, 4, strStatus);
		m_listUser.SetItemText(nItem, 5, strSL);
		nItem++;
	}
	free( pUser );

	m_ctrlUType.AddString(_T("VIP"));
	m_ctrlUType.AddString(_T("Ordinary"));
	m_ctrlUType.SetCurSel(0);
	m_ctrlStatus.AddString(_T("Active"));
	m_ctrlStatus.AddString(_T("Suspend"));
	m_ctrlStatus.SetCurSel(0);
	m_ctrlSL.AddString(_T("0"));
	m_ctrlSL.AddString(_T("1"));
	m_ctrlSL.AddString(_T("2"));
	m_ctrlSL.AddString(_T("3"));
	m_ctrlSL.SetCurSel(0);

	if( m_bShowUType )
	{
		m_lblGID.ShowWindow(SW_SHOW);
		m_lblUID.ShowWindow(SW_SHOW);
		m_lblFID.ShowWindow(SW_SHOW);
		m_ctrlGID.ShowWindow(SW_SHOW);
		m_ctrlUID.ShowWindow(SW_SHOW);
		m_ctrlFID.ShowWindow(SW_SHOW);
		m_gbChange.ShowWindow(SW_SHOW);
		m_lblUType.ShowWindow(SW_SHOW);
		m_ctrlUType.ShowWindow(SW_SHOW);
		m_lblStatus.ShowWindow(SW_SHOW);
		m_ctrlStatus.ShowWindow(SW_SHOW);
		m_lblSL.ShowWindow(SW_SHOW);
		m_ctrlSL.ShowWindow(SW_SHOW);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDlgUserList::OnBnClickedOk()
{
	GetUserInfo();
}


void CDlgUserList::OnNMDblclkListUser(NMHDR *pNMHDR, LRESULT *pResult)
{
	GetUserInfo();
	*pResult = 0;
}

void CDlgUserList::OnLvnItemchangedListUser(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);

	if( m_bShowUType )
	{
		int nSelected = -1;
		nSelected = m_listUser.GetNextItem(nSelected, LVNI_SELECTED);
		if( nSelected != -1 )
		{
			CString strGID = m_listUser.GetItemText(nSelected, 0);
			CString strUID = m_listUser.GetItemText(nSelected, 1);
			CString strFID = m_listUser.GetItemText(nSelected, 2);
			CString strUType = m_listUser.GetItemText(nSelected, 3);
			CString strStatus = m_listUser.GetItemText(nSelected, 4);
			CString strSL = m_listUser.GetItemText(nSelected, 5);
		
			m_ctrlGID.SetWindowTextW( strGID );
			m_ctrlUID.SetWindowTextW( strUID );
			m_ctrlFID.SetWindowTextW( strFID );
			nSelected = _wtoi( strSL );
			m_ctrlSL.SetCurSel(nSelected);
			m_nUTypeOld = nSelected;
			if( strUType.Compare(_T("VIP")) == 0 )
			{
				m_ctrlUType.SetCurSel(0);
				m_nUTypeOld += 0x04;
			}
			else
				m_ctrlUType.SetCurSel(1);
			if( strStatus.Compare(_T("Suspend")) == 0 )
			{
				m_ctrlStatus.SetCurSel(1);
				m_nUTypeOld += 0x08;
			}
			else
				m_ctrlStatus.SetCurSel(0);
		}
		else
		{
			m_ctrlUID.SetWindowTextW(_T(""));
			m_ctrlUType.SetCurSel(0);
			m_ctrlSL.SetCurSel(2);
		}
	}

	*pResult = 0;
}


void CDlgUserList::GetUserInfo()
{
	int nSelected = -1;
	nSelected = m_listUser.GetNextItem(nSelected, LVNI_SELECTED);
	if( nSelected != -1 )
	{
		CString strTemp = m_listUser.GetItemText(nSelected, 0);
		m_nGroupID = (BYTE)_wtoi( (LPCTSTR)strTemp );
		strTemp = m_listUser.GetItemText( nSelected, 1 );
		unsigned __int64 ui64UID = _wtoi64( (LPCTSTR)strTemp );
		m_nID_L = (UINT) ui64UID;
		m_nID_H = (UINT) (ui64UID / 0x100000000);
		strTemp = m_listUser.GetItemText( nSelected, 2 );
		m_nFingerID = (BYTE)_wtoi( (LPCTSTR)strTemp );
		if( m_bShowUType )
		{
			int nIndex = m_ctrlSL.GetCurSel();
			m_ctrlSL.GetLBText(nIndex, strTemp);
			m_nUType = _wtoi(strTemp);

			nIndex = m_ctrlUType.GetCurSel();
			m_ctrlUType.GetLBText(nIndex, strTemp);
			if( strTemp.Compare(_T("VIP")) == 0 )
				m_nUType += 0x04;

			nIndex = m_ctrlStatus.GetCurSel();
			m_ctrlStatus.GetLBText(nIndex, strTemp);
			if( strTemp.Compare(_T("Suspend")) == 0 )
				m_nUType += 0x08;
		}
		OnOK();
	}
	else
	{
		MessageBox(_T("Please select a user id!"), 0, MB_OK|MB_ICONSTOP);
	}
}
